/*
 * Decompiled with CFR 0.152.
 */
package com.samuel.spectrite.entities;

import com.google.common.collect.Sets;
import com.samuel.spectrite.Spectrite;
import com.samuel.spectrite.helpers.SpectriteHelper;
import com.samuel.spectrite.init.ModPotions;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntitySpectriteTippedArrow
extends EntityArrow {
    private PotionType potionType = PotionTypes.field_185229_a;
    private Potion potion;
    private final Set<PotionEffect> customPotionEffects = Sets.newHashSet();

    public EntitySpectriteTippedArrow(EntityTippedArrow arrow, PotionType potionType) {
        super(arrow.func_130014_f_(), arrow.field_70250_c != null ? (EntityLivingBase)arrow.field_70250_c : null);
        float velocity = Math.min(arrow.func_130014_f_().field_73012_v.nextFloat() + 0.25f, 1.0f);
        if (this.field_70250_c != null) {
            this.func_184547_a(this.field_70250_c, this.field_70250_c.field_70125_A, this.field_70250_c.field_70177_z, 0.0f, velocity * 3.0f, 1.0f);
        }
        if (velocity == 1.0f) {
            this.func_70243_d(true);
        }
        this.setPotionEffect(potionType);
    }

    public EntitySpectriteTippedArrow(World worldIn) {
        super(worldIn);
    }

    public void setPotionEffect(PotionType potionType) {
        this.potionType = potionType;
        if (!potionType.func_185170_a().isEmpty()) {
            PotionEffect potionEffect = (PotionEffect)potionType.func_185170_a().get(0);
            this.potion = potionEffect.func_188419_a();
            this.customPotionEffects.add(potionEffect);
        }
    }

    public void addEffect(PotionEffect effect) {
        this.customPotionEffects.add(effect);
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            if (this.field_70254_i) {
                if (this.field_184552_b % 5 == 0) {
                    this.spawnPotionParticles(1);
                }
            } else {
                this.spawnPotionParticles(2);
            }
        } else if (this.field_70254_i && this.field_184552_b != 0 && !this.customPotionEffects.isEmpty() && this.field_184552_b >= 600) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)0);
            this.potionType = PotionTypes.field_185229_a;
            this.customPotionEffects.clear();
        }
    }

    private void spawnPotionParticles(int particleCount) {
        int offsetLevel = this.potionType == PotionTypes.field_185229_a || ModPotions.SPECTRITE.equals(this.potion) ? 0 : (ModPotions.SPECTRITE_DAMAGE.equals(this.potion) ? 1 : 2);
        int i = SpectriteHelper.getCurrentSpectriteColour(offsetLevel);
        if (particleCount > 0) {
            double d0 = (double)(i >> 16 & 0xFF) / 255.0;
            double d1 = (double)(i >> 8 & 0xFF) / 255.0;
            double d2 = (double)(i >> 0 & 0xFF) / 255.0;
            for (int j = 0; j < particleCount; ++j) {
                Spectrite.Proxy.spawnSpectriteSpellParticle(this.field_70170_p, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, d0, d1, d2, offsetLevel);
            }
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.potionType != PotionTypes.field_185229_a && this.potionType != null) {
            compound.func_74778_a("Potion", ((ResourceLocation)PotionType.field_185176_a.func_177774_c((Object)this.potionType)).toString());
        }
        if (!this.customPotionEffects.isEmpty()) {
            NBTTagList nbttaglist = new NBTTagList();
            for (PotionEffect potioneffect : this.customPotionEffects) {
                nbttaglist.func_74742_a((NBTBase)potioneffect.func_82719_a(new NBTTagCompound()));
            }
            compound.func_74782_a("CustomPotionEffects", (NBTBase)nbttaglist);
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("Potion", 8)) {
            this.potionType = PotionUtils.func_185187_c((NBTTagCompound)compound);
        }
        for (PotionEffect potioneffect : PotionUtils.func_185192_b((NBTTagCompound)compound)) {
            this.addEffect(potioneffect);
        }
    }

    protected void func_184548_a(EntityLivingBase living) {
        super.func_184548_a(living);
        for (PotionEffect potioneffect : this.potionType.func_185170_a()) {
            living.func_70690_d(new PotionEffect(potioneffect.func_188419_a(), Math.max(potioneffect.func_76459_b() / 8, 1), potioneffect.func_76458_c(), potioneffect.func_82720_e(), potioneffect.func_188418_e()));
        }
        if (!this.customPotionEffects.isEmpty()) {
            for (PotionEffect potioneffect1 : this.customPotionEffects) {
                living.func_70690_d(potioneffect1);
            }
        }
    }

    protected ItemStack func_184550_j() {
        if (this.customPotionEffects.isEmpty() && this.potionType == PotionTypes.field_185229_a) {
            return new ItemStack(Items.field_151032_g);
        }
        ItemStack itemstack = new ItemStack(Items.field_185167_i);
        PotionUtils.func_185188_a((ItemStack)itemstack, (PotionType)this.potionType);
        PotionUtils.func_185184_a((ItemStack)itemstack, this.customPotionEffects);
        return itemstack;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 0) {
            int offsetLevel = this.potionType == PotionTypes.field_185229_a || ModPotions.SPECTRITE.equals(this.potion) ? 0 : (ModPotions.SPECTRITE_DAMAGE.equals(this.potion) ? 1 : 2);
            int i = SpectriteHelper.getCurrentSpectriteColour(offsetLevel);
            if (i != -1) {
                double d0 = (double)(i >> 16 & 0xFF) / 255.0;
                double d1 = (double)(i >> 8 & 0xFF) / 255.0;
                double d2 = (double)(i >> 0 & 0xFF) / 255.0;
                for (int j = 0; j < 20; ++j) {
                    Spectrite.Proxy.spawnSpectriteSpellParticle(this.field_70170_p, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, d0, d1, d2, offsetLevel);
                }
            }
        } else {
            super.func_70103_a(id);
        }
    }
}

