/*
 * Decompiled with CFR 0.152.
 */
package com.samuel.spectrite.entities;

import com.google.common.base.Predicate;
import com.samuel.spectrite.entities.EntitySpectriteCreeper;
import com.samuel.spectrite.entities.ISpectriteMob;
import com.samuel.spectrite.init.ModBiomes;
import com.samuel.spectrite.init.ModLootTables;
import com.samuel.spectrite.init.ModSounds;
import java.lang.reflect.Field;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntitySpectriteGolem
extends EntityIronGolem
implements ISpectriteMob {
    private int healTimer;
    private static Field attackTimerField = null;

    public EntitySpectriteGolem(World worldIn) {
        super(worldIn);
        this.initEntityAIAttackableTarget(false);
        this.field_70728_aV = 77;
    }

    public EntitySpectriteGolem(World worldIn, boolean playerCreated) {
        super(worldIn);
        this.func_70849_f(playerCreated);
        this.initEntityAIAttackableTarget(playerCreated);
        if (!playerCreated) {
            this.field_70728_aV = 77;
        }
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMoveTowardsTarget((EntityCreature)this, 0.9, 32.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[]{EntitySpectriteGolem.class}));
    }

    protected void initEntityAIAttackableTarget(boolean playerCreated) {
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLiving.class, 10, false, true, (Predicate)(!playerCreated ? new Predicate<EntityLiving>(){

            public boolean apply(@Nullable EntityLiving p_apply_1_) {
                return p_apply_1_ != null && IMob.field_175450_e.apply((Object)p_apply_1_) && !(p_apply_1_ instanceof ISpectriteMob) && !(p_apply_1_ instanceof EntityCreeper);
            }
        } : new Predicate<EntityLiving>(){

            public boolean apply(@Nullable EntityLiving p_apply_1_) {
                return p_apply_1_ != null && IMob.field_175450_e.apply((Object)p_apply_1_) && !(p_apply_1_ instanceof EntityCreeper);
            }
        })));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(250.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.175);
    }

    protected void func_82167_n(Entity entityIn) {
        if (!this.func_70850_q() && entityIn instanceof EntityPlayer && !((EntityPlayer)entityIn).func_184812_l_() && this.func_70681_au().nextInt(20) == 0) {
            this.func_70624_b((EntityLivingBase)entityIn);
        }
        if (this.func_70850_q() || !ISpectriteMob.class.isAssignableFrom(entityIn.getClass())) {
            super.func_82167_n(entityIn);
        } else {
            entityIn.func_70108_f((Entity)this);
        }
    }

    public boolean func_70686_a(Class<? extends EntityLivingBase> cls) {
        if (this.func_70850_q() && EntityPlayer.class.isAssignableFrom(cls)) {
            return false;
        }
        return cls == EntitySpectriteCreeper.class || !this.func_70850_q() && ISpectriteMob.class.isAssignableFrom(cls) ? false : super.func_70686_a(cls);
    }

    public boolean func_70652_k(Entity entityIn) {
        this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)(15 + this.field_70146_Z.nextInt(10)));
        if (flag) {
            entityIn.field_70181_x += (double)0.4f;
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        this.func_184185_a(ModSounds.spectrite_golem_attack, 1.0f, 1.0f);
        return flag;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 4) {
            if (attackTimerField == null) {
                attackTimerField = ObfuscationReflectionHelper.findField(EntityIronGolem.class, (String)"field_70855_f");
            }
            try {
                attackTimerField.set(this, 10);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            this.func_184185_a(ModSounds.spectrite_golem_attack, 1.0f, 1.0f);
        } else if (id != 11 && id != 34) {
            super.func_70103_a(id);
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            if (this.healTimer > 0) {
                --this.healTimer;
            } else {
                this.func_70691_i(1.0f);
                this.healTimer = 50;
            }
        }
    }

    public boolean func_70601_bi() {
        BlockPos pos = new BlockPos((Entity)this);
        if (this.field_70170_p.func_180494_b(pos) != ModBiomes.spectrite_dungeon) {
            return true;
        }
        int spawnChance = pos.func_177956_o() + 8 >> 3;
        boolean shouldSpawn = spawnChance == 1 || spawnChance == 2 && this.field_70146_Z.nextBoolean() || spawnChance == 3 && this.field_70146_Z.nextInt(3) == 0;
        return shouldSpawn && pos.func_177977_b().func_177956_o() < 28 && this.field_70170_p.func_175647_a(EntitySpectriteGolem.class, new AxisAlignedBB(pos.func_177965_g(8).func_177970_e(8).func_177977_b(), pos.func_177985_f(8).func_177964_d(8).func_177981_b(8)), EntitySelectors.field_94557_a).size() < 1 && super.func_70601_bi();
    }

    public boolean func_184191_r(Entity entityIn) {
        return entityIn instanceof ISpectriteMob && (entityIn.getClass() != EntitySpectriteGolem.class || ((EntitySpectriteGolem)entityIn).func_70850_q() == this.func_70850_q()) || super.func_184191_r(entityIn);
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return ModSounds.spectrite_golem_hurt;
    }

    protected SoundEvent func_184615_bR() {
        return ModSounds.spectrite_golem_death;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(ModSounds.spectrite_golem_step, 1.0f, 1.0f);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return ModLootTables.spectrite_golem;
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.initEntityAIAttackableTarget(this.func_70850_q());
    }
}

