/*
 * Decompiled with CFR 0.152.
 */
package com.samuel.spectrite.entities;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import com.samuel.spectrite.Spectrite;
import com.samuel.spectrite.SpectriteConfig;
import com.samuel.spectrite.damagesources.DamageSourceSpectriteIndirectPlayer;
import com.samuel.spectrite.entities.ISpectriteMob;
import com.samuel.spectrite.init.ModBiomes;
import com.samuel.spectrite.init.ModBlocks;
import com.samuel.spectrite.init.ModItems;
import com.samuel.spectrite.init.ModPotions;
import com.samuel.spectrite.init.ModSounds;
import com.samuel.spectrite.items.ItemSpectriteOrb;
import com.samuel.spectrite.items.ItemSpectriteSkull;
import java.lang.reflect.Field;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityEndermite;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.Event;

public class EntitySpectriteEnderman
extends EntityMob
implements ISpectriteMob {
    private static final UUID ATTACKING_SPEED_BOOST_ID = UUID.fromString("020E0DFB-87AE-4653-9556-831010E291A0");
    private static final AttributeModifier ATTACKING_SPEED_BOOST = new AttributeModifier(ATTACKING_SPEED_BOOST_ID, "Attacking speed boost", 0.24270000964, 0).func_111168_a(false);
    private static final Set<Block> CARRIABLE_BLOCKS = Sets.newIdentityHashSet();
    private static final DataParameter<Optional<IBlockState>> CARRIED_BLOCK = EntityDataManager.func_187226_a(EntitySpectriteEnderman.class, (DataSerializer)DataSerializers.field_187197_g);
    private static final DataParameter<Boolean> SCREAMING = EntityDataManager.func_187226_a(EntitySpectriteEnderman.class, (DataSerializer)DataSerializers.field_187198_h);
    private int lastCreepySound;
    private int targetChangeTime;

    public EntitySpectriteEnderman(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.6f, 2.9f);
        this.field_70138_W = 1.0f;
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.field_70728_aV = 70;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0, 0.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new AIPlaceBlock(this));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new AITakeBlock(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new AIFindPlayer(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityEndermite.class, 10, true, false, (Predicate)new Predicate<EntityEndermite>(){

            public boolean apply(@Nullable EntityEndermite p_apply_1_) {
                return p_apply_1_.func_175495_n();
            }
        }));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(100.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.48540001928);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(96.0);
    }

    public void func_70624_b(@Nullable EntityLivingBase entitylivingbaseIn) {
        super.func_70624_b(entitylivingbaseIn);
        IAttributeInstance iattributeinstance = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
        if (entitylivingbaseIn == null) {
            this.targetChangeTime = 0;
            this.field_70180_af.func_187227_b(SCREAMING, (Object)false);
            iattributeinstance.func_111124_b(ATTACKING_SPEED_BOOST);
        } else {
            this.targetChangeTime = this.field_70173_aa;
            this.field_70180_af.func_187227_b(SCREAMING, (Object)true);
            if (!iattributeinstance.func_180374_a(ATTACKING_SPEED_BOOST)) {
                iattributeinstance.func_111121_a(ATTACKING_SPEED_BOOST);
            }
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CARRIED_BLOCK, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(SCREAMING, (Object)false);
    }

    public void playEndermanSound() {
        if (this.field_70173_aa >= this.lastCreepySound + 400) {
            this.lastCreepySound = this.field_70173_aa;
            if (!this.func_174814_R()) {
                this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v, ModSounds.spectrite_enderman_stare, this.func_184176_by(), 2.5f, 1.0f, false);
            }
        }
    }

    public void func_184206_a(DataParameter<?> key) {
        if (SCREAMING.equals(key) && this.isScreaming() && this.field_70170_p.field_72995_K) {
            this.playEndermanSound();
        }
        super.func_184206_a(key);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        IBlockState iblockstate = this.getHeldBlockState();
        if (iblockstate != null) {
            compound.func_74777_a("carried", (short)Block.func_149682_b((Block)iblockstate.func_177230_c()));
            compound.func_74777_a("carriedData", (short)iblockstate.func_177230_c().func_176201_c(iblockstate));
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        IBlockState iblockstate = compound.func_150297_b("carried", 8) ? Block.func_149684_b((String)compound.func_74779_i("carried")).func_176203_a(compound.func_74765_d("carriedData") & 0xFFFF) : Block.func_149729_e((int)compound.func_74765_d("carried")).func_176203_a(compound.func_74765_d("carriedData") & 0xFFFF);
        if (iblockstate == null || iblockstate.func_177230_c() == null || iblockstate.func_185904_a() == Material.field_151579_a) {
            iblockstate = null;
        }
        this.setHeldBlockState(iblockstate);
    }

    private boolean shouldAttackPlayer(EntityPlayer player) {
        ItemStack itemstack = (ItemStack)player.field_71071_by.field_70460_b.get(3);
        if (itemstack.func_77973_b() instanceof ItemSpectriteSkull) {
            return false;
        }
        Vec3d vec3d = player.func_70676_i(1.0f).func_72432_b();
        Vec3d vec3d1 = new Vec3d(this.field_70165_t - player.field_70165_t, this.func_174813_aQ().field_72338_b + (double)this.func_70047_e() - (player.field_70163_u + (double)player.func_70047_e()), this.field_70161_v - player.field_70161_v);
        double d0 = vec3d1.func_72433_c();
        double d1 = vec3d.func_72430_b(vec3d1 = vec3d1.func_72432_b());
        return d1 > 1.0 - 0.025 / d0 ? player.func_70685_l((Entity)this) : false;
    }

    public float func_70047_e() {
        return 2.55f;
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                Spectrite.Proxy.spawnSpectritePortalParticle(this.field_70170_p, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - 0.25, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0);
            }
        }
        this.field_70703_bu = false;
        super.func_70636_d();
    }

    protected void func_70619_bc() {
        float f;
        if (this.func_70026_G()) {
            this.func_70097_a(DamageSource.field_76369_e, 1.0f);
        }
        if (this.field_70170_p.func_72935_r() && this.field_70173_aa >= this.targetChangeTime + 600 && (f = this.func_70013_c()) > 0.5f && this.field_70170_p.func_175678_i(new BlockPos((Entity)this)) && this.field_70146_Z.nextFloat() * 30.0f < (f - 0.4f) * 2.0f) {
            this.func_70624_b(null);
            this.teleportRandomly();
        }
        super.func_70619_bc();
    }

    protected boolean teleportRandomly() {
        double d0 = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
        double d1 = this.field_70163_u + (double)(this.field_70146_Z.nextInt(64) - 32);
        double d2 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
        return this.teleportTo(d0, d1, d2);
    }

    protected boolean teleportToEntity(Entity p_70816_1_) {
        Vec3d vec3d = new Vec3d(this.field_70165_t - p_70816_1_.field_70165_t, this.func_174813_aQ().field_72338_b + (double)(this.field_70131_O / 2.0f) - p_70816_1_.field_70163_u + (double)p_70816_1_.func_70047_e(), this.field_70161_v - p_70816_1_.field_70161_v);
        vec3d = vec3d.func_72432_b();
        double d1 = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec3d.field_72450_a * 16.0;
        double d2 = this.field_70163_u + (double)(this.field_70146_Z.nextInt(16) - 8) - vec3d.field_72448_b * 16.0;
        double d3 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec3d.field_72449_c * 16.0;
        return this.teleportTo(d1, d2, d3);
    }

    private boolean teleportTo(double x, double y, double z) {
        EnderTeleportEvent event = new EnderTeleportEvent((EntityLivingBase)this, x, y, z, 0.0f);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        boolean flag = this.func_184595_k(event.getTargetX(), event.getTargetY(), event.getTargetZ());
        if (flag) {
            this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70169_q, this.field_70167_r, this.field_70166_s, ModSounds.spectrite_enderman_teleport, this.func_184176_by(), 1.0f, 1.0f);
            this.func_184185_a(ModSounds.spectrite_enderman_teleport, 1.0f, 1.0f);
        }
        return flag;
    }

    public boolean func_184595_k(double x, double y, double z) {
        double d0 = this.field_70165_t;
        double d1 = this.field_70163_u;
        double d2 = this.field_70161_v;
        this.field_70165_t = x;
        this.field_70163_u = y;
        this.field_70161_v = z;
        boolean flag = false;
        BlockPos blockpos = new BlockPos((Entity)this);
        World world = this.field_70170_p;
        Random random = this.func_70681_au();
        if (world.func_175667_e(blockpos)) {
            boolean flag1 = false;
            while (!flag1 && blockpos.func_177956_o() > 0) {
                BlockPos blockpos1 = blockpos.func_177977_b();
                IBlockState iblockstate = world.func_180495_p(blockpos1);
                if (iblockstate.func_185904_a().func_76230_c()) {
                    flag1 = true;
                    continue;
                }
                this.field_70163_u -= 1.0;
                blockpos = blockpos1;
            }
            if (flag1) {
                this.func_70634_a(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                if (world.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty() && !world.func_72953_d(this.func_174813_aQ())) {
                    flag = true;
                }
            }
        }
        if (!flag) {
            this.func_70634_a(d0, d1, d2);
            return false;
        }
        for (int j = 0; j < 128; ++j) {
            double d6 = (double)j / 127.0;
            float f = (random.nextFloat() - 0.5f) * 0.2f;
            float f1 = (random.nextFloat() - 0.5f) * 0.2f;
            float f2 = (random.nextFloat() - 0.5f) * 0.2f;
            double d3 = d0 + (this.field_70165_t - d0) * d6 + (random.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
            double d4 = d1 + (this.field_70163_u - d1) * d6 + random.nextDouble() * (double)this.field_70131_O;
            double d5 = d2 + (this.field_70161_v - d2) * d6 + (random.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
            Spectrite.Proxy.spawnSpectritePortalParticle(this.field_70170_p, d3, d4, d5, f, f1, f2);
        }
        this.func_70661_as().func_75499_g();
        return true;
    }

    protected SoundEvent func_184639_G() {
        return this.isScreaming() ? ModSounds.spectrite_enderman_scream : ModSounds.spectrite_enderman_ambient;
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return ModSounds.spectrite_enderman_hurt;
    }

    protected SoundEvent func_184615_bR() {
        return ModSounds.spectrite_enderman_death;
    }

    protected void func_82160_b(boolean wasRecentlyHit, int lootingModifier) {
        super.func_82160_b(wasRecentlyHit, lootingModifier);
        IBlockState iblockstate = this.getHeldBlockState();
        if (iblockstate != null) {
            Item item = Item.func_150898_a((Block)iblockstate.func_177230_c());
            int i = item.func_77614_k() ? iblockstate.func_177230_c().func_176201_c(iblockstate) : 0;
            this.func_70099_a(new ItemStack(item, 1, i), 0.0f);
        }
    }

    protected void func_184610_a(boolean wasRecentlyHit, int lootingModifier, DamageSource source) {
        EntityPlayer damageSourceEntity;
        if (source instanceof DamageSourceSpectriteIndirectPlayer) {
            damageSourceEntity = ((DamageSourceSpectriteIndirectPlayer)source).getPlayer();
        } else {
            Entity entity = damageSourceEntity = source.func_76346_g() != null ? source.func_76346_g() : source.func_76364_f();
        }
        lootingModifier = damageSourceEntity == null || !(damageSourceEntity instanceof EntityPlayer) && (!(damageSourceEntity instanceof EntityIronGolem) || !((EntityIronGolem)damageSourceEntity).func_70850_q()) ? -1 : (((EntityLivingBase)damageSourceEntity).func_70660_b(ModPotions.PROSPERITY) != null ? ((EntityLivingBase)damageSourceEntity).func_70660_b(ModPotions.PROSPERITY).func_76458_c() + 1 : 0);
        if (lootingModifier >= 0 && SpectriteConfig.mobs.spectriteEndermanOrbDropRate > 0.0 && (double)(this.field_70146_Z.nextFloat() * 100.0f) < SpectriteConfig.mobs.spectriteEndermanOrbDropRate) {
            this.func_70628_a(wasRecentlyHit, lootingModifier);
        }
    }

    protected void func_70628_a(boolean wasRecentlyHit, int lootingModifier) {
        int numDrops = lootingModifier > 0 ? (lootingModifier == 1 ? (this.field_70146_Z.nextInt(7) >= 2 ? 1 : 2) : 2) : 1;
        for (int d = 0; d < numDrops; ++d) {
            EntityItem entityitem = this.func_70099_a(new ItemStack((Item)ModItems.spectrite_orb, 1, ItemSpectriteOrb.ORB_COLOURS[this.field_70146_Z.nextInt(ItemSpectriteOrb.ORB_COLOURS.length)]), 0.0f);
            if (entityitem == null) continue;
            entityitem.func_174873_u();
        }
    }

    public void setHeldBlockState(@Nullable IBlockState state) {
        this.field_70180_af.func_187227_b(CARRIED_BLOCK, (Object)Optional.fromNullable((Object)state));
    }

    @Nullable
    public IBlockState getHeldBlockState() {
        return (IBlockState)((Optional)this.field_70180_af.func_187225_a(CARRIED_BLOCK)).orNull();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        boolean flag;
        if (this.func_180431_b(source)) {
            return false;
        }
        if (source instanceof EntityDamageSourceIndirect && !source.func_76355_l().equals("spectrite")) {
            for (int i = 0; i < 64; ++i) {
                if (!this.teleportRandomly()) continue;
                return true;
            }
            return false;
        }
        boolean weakAttack = amount < 10.0f;
        boolean bl = flag = !weakAttack && super.func_70097_a(source, amount);
        if (weakAttack || source.func_76363_c() && this.field_70146_Z.nextInt(10) != 0) {
            this.teleportRandomly();
        }
        return flag;
    }

    public static void setCarriable(Block block, boolean canCarry) {
        if (canCarry) {
            CARRIABLE_BLOCKS.add(block);
        } else {
            CARRIABLE_BLOCKS.remove(block);
        }
    }

    public static boolean getCarriable(Block block) {
        return CARRIABLE_BLOCKS.contains(block);
    }

    public static void initCarriableBlocks() {
        Field endermanCarriableBlocksField = ObfuscationReflectionHelper.findField(EntityEnderman.class, (String)"field_70827_d");
        Set endermanCarriableBlocks = null;
        try {
            endermanCarriableBlocks = (Set)endermanCarriableBlocksField.get(null);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        if (endermanCarriableBlocks != null) {
            CARRIABLE_BLOCKS.addAll(endermanCarriableBlocks);
        }
        CARRIABLE_BLOCKS.add(ModBlocks.spectrite_sand);
    }

    public boolean isScreaming() {
        return (Boolean)this.field_70180_af.func_187225_a(SCREAMING);
    }

    public boolean func_70601_bi() {
        BlockPos pos = new BlockPos((Entity)this);
        if (this.field_70170_p.func_180494_b(pos) != ModBiomes.spectrite_dungeon) {
            return true;
        }
        int spawnChance = pos.func_177956_o() + 8 >> 3;
        boolean shouldSpawn = spawnChance == 1 || spawnChance == 2 && this.field_70146_Z.nextBoolean() || spawnChance == 3 && this.field_70146_Z.nextInt(3) == 0;
        return shouldSpawn && pos.func_177977_b().func_177956_o() < 28;
    }

    static class AITakeBlock
    extends EntityAIBase {
        private final EntitySpectriteEnderman spectriteEnderman;

        public AITakeBlock(EntitySpectriteEnderman p_i45841_1_) {
            this.spectriteEnderman = p_i45841_1_;
        }

        public boolean func_75250_a() {
            if (this.spectriteEnderman.getHeldBlockState() != null) {
                return false;
            }
            if (!this.spectriteEnderman.field_70170_p.func_82736_K().func_82766_b("mobGriefing")) {
                return false;
            }
            return this.spectriteEnderman.func_70681_au().nextInt(20) == 0;
        }

        public void func_75246_d() {
            boolean flag;
            Random random = this.spectriteEnderman.func_70681_au();
            World world = this.spectriteEnderman.field_70170_p;
            int i = MathHelper.func_76128_c((double)(this.spectriteEnderman.field_70165_t - 2.0 + random.nextDouble() * 4.0));
            int j = MathHelper.func_76128_c((double)(this.spectriteEnderman.field_70163_u + random.nextDouble() * 3.0));
            int k = MathHelper.func_76128_c((double)(this.spectriteEnderman.field_70161_v - 2.0 + random.nextDouble() * 4.0));
            BlockPos blockpos = new BlockPos(i, j, k);
            IBlockState iblockstate = world.func_180495_p(blockpos);
            Block block = iblockstate.func_177230_c();
            RayTraceResult raytraceresult = world.func_147447_a(new Vec3d((double)((float)MathHelper.func_76128_c((double)this.spectriteEnderman.field_70165_t) + 0.5f), (double)((float)j + 0.5f), (double)((float)MathHelper.func_76128_c((double)this.spectriteEnderman.field_70161_v) + 0.5f)), new Vec3d((double)((float)i + 0.5f), (double)((float)j + 0.5f), (double)((float)k + 0.5f)), false, true, false);
            boolean bl = flag = raytraceresult != null && raytraceresult.func_178782_a().equals((Object)blockpos);
            if (CARRIABLE_BLOCKS.contains(block) && flag) {
                this.spectriteEnderman.setHeldBlockState(iblockstate);
                world.func_175698_g(blockpos);
            }
        }
    }

    static class AIPlaceBlock
    extends EntityAIBase {
        private final EntitySpectriteEnderman spectriteEnderman;

        public AIPlaceBlock(EntitySpectriteEnderman p_i45843_1_) {
            this.spectriteEnderman = p_i45843_1_;
        }

        public boolean func_75250_a() {
            if (this.spectriteEnderman.getHeldBlockState() == null) {
                return false;
            }
            if (!this.spectriteEnderman.field_70170_p.func_82736_K().func_82766_b("mobGriefing")) {
                return false;
            }
            return this.spectriteEnderman.func_70681_au().nextInt(2000) == 0;
        }

        public void func_75246_d() {
            Random random = this.spectriteEnderman.func_70681_au();
            World world = this.spectriteEnderman.field_70170_p;
            int i = MathHelper.func_76128_c((double)(this.spectriteEnderman.field_70165_t - 1.0 + random.nextDouble() * 2.0));
            int j = MathHelper.func_76128_c((double)(this.spectriteEnderman.field_70163_u + random.nextDouble() * 2.0));
            int k = MathHelper.func_76128_c((double)(this.spectriteEnderman.field_70161_v - 1.0 + random.nextDouble() * 2.0));
            BlockPos blockpos = new BlockPos(i, j, k);
            IBlockState iblockstate = world.func_180495_p(blockpos);
            IBlockState iblockstate1 = world.func_180495_p(blockpos.func_177977_b());
            IBlockState iblockstate2 = this.spectriteEnderman.getHeldBlockState();
            if (iblockstate2 != null && this.canPlaceBlock(world, blockpos, iblockstate2.func_177230_c(), iblockstate, iblockstate1)) {
                world.func_180501_a(blockpos, iblockstate2, 3);
                this.spectriteEnderman.setHeldBlockState(null);
            }
        }

        private boolean canPlaceBlock(World p_188518_1_, BlockPos p_188518_2_, Block p_188518_3_, IBlockState p_188518_4_, IBlockState p_188518_5_) {
            if (!p_188518_3_.func_176196_c(p_188518_1_, p_188518_2_)) {
                return false;
            }
            if (p_188518_4_.func_185904_a() != Material.field_151579_a) {
                return false;
            }
            if (p_188518_5_.func_185904_a() == Material.field_151579_a) {
                return false;
            }
            return p_188518_5_.func_185917_h();
        }
    }

    static class AIFindPlayer
    extends EntityAINearestAttackableTarget<EntityPlayer> {
        private final EntitySpectriteEnderman spectriteEnderman;
        private EntityPlayer player;
        private int aggroTime;
        private int teleportTime;

        public AIFindPlayer(EntitySpectriteEnderman p_i45842_1_) {
            super((EntityCreature)p_i45842_1_, EntityPlayer.class, false);
            this.spectriteEnderman = p_i45842_1_;
        }

        public boolean func_75250_a() {
            double d0 = this.func_111175_f();
            this.player = this.spectriteEnderman.field_70170_p.func_184150_a(this.spectriteEnderman.field_70165_t, this.spectriteEnderman.field_70163_u, this.spectriteEnderman.field_70161_v, d0, d0, (Function)null, (Predicate)new Predicate<EntityPlayer>(){

                public boolean apply(@Nullable EntityPlayer p_apply_1_) {
                    return p_apply_1_ != null && spectriteEnderman.shouldAttackPlayer(p_apply_1_);
                }
            });
            return this.player != null;
        }

        public void func_75249_e() {
            this.aggroTime = 5;
            this.teleportTime = 0;
        }

        public void func_75251_c() {
            this.player = null;
            super.func_75251_c();
        }

        public boolean func_75253_b() {
            if (this.player != null) {
                if (!this.spectriteEnderman.shouldAttackPlayer(this.player)) {
                    return false;
                }
                this.spectriteEnderman.func_70625_a((Entity)this.player, 10.0f, 10.0f);
                return true;
            }
            return this.field_75309_a != null && ((EntityPlayer)this.field_75309_a).func_70089_S() ? true : super.func_75253_b();
        }

        public void func_75246_d() {
            if (this.player != null) {
                if (--this.aggroTime <= 0) {
                    this.field_75309_a = this.player;
                    this.player = null;
                    super.func_75249_e();
                }
            } else {
                if (this.field_75309_a != null) {
                    if (this.spectriteEnderman.shouldAttackPlayer((EntityPlayer)this.field_75309_a)) {
                        if (((EntityPlayer)this.field_75309_a).func_70068_e((Entity)this.spectriteEnderman) < 16.0) {
                            this.spectriteEnderman.teleportRandomly();
                        }
                        this.teleportTime = 0;
                    } else if (((EntityPlayer)this.field_75309_a).func_70068_e((Entity)this.spectriteEnderman) > 256.0 && this.teleportTime++ >= 30 && this.spectriteEnderman.teleportToEntity((Entity)this.field_75309_a)) {
                        this.teleportTime = 0;
                    }
                }
                super.func_75246_d();
            }
        }
    }
}

