/*
 * Decompiled with CFR 0.152.
 */
package com.samuel.spectrite.entities;

import com.samuel.spectrite.Spectrite;
import com.samuel.spectrite.entities.EntitySpectriteAreaEffectCloud;
import com.samuel.spectrite.entities.EntitySpectriteGolem;
import com.samuel.spectrite.entities.ISpectriteMob;
import com.samuel.spectrite.init.ModBiomes;
import com.samuel.spectrite.init.ModLootTables;
import com.samuel.spectrite.init.ModPotions;
import com.samuel.spectrite.init.ModSounds;
import com.samuel.spectrite.items.ItemSpectriteShield;
import com.samuel.spectrite.items.ItemSpectriteShieldSpecial;
import java.lang.reflect.Field;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.item.ItemShield;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class EntitySpectriteCreeper
extends EntityCreeper
implements ISpectriteMob {
    private final int explosionRadius = 4;
    private static Field timeSinceIgnitedField = null;
    private static Field fuseTimeField = null;

    public EntitySpectriteCreeper(World worldIn) {
        super(worldIn);
        if (timeSinceIgnitedField == null) {
            timeSinceIgnitedField = ObfuscationReflectionHelper.findField(EntityCreeper.class, (String)"field_70833_d");
        }
        if (fuseTimeField == null) {
            fuseTimeField = ObfuscationReflectionHelper.findField(EntityCreeper.class, (String)"field_82225_f");
        }
        this.field_70728_aV = 25;
    }

    public void func_70071_h_() {
        if (this.func_70089_S()) {
            int i = this.func_70832_p();
            int timeSinceIgnited = 0;
            int fuseTime = 0;
            try {
                timeSinceIgnited = (Integer)timeSinceIgnitedField.get(this) + i;
                fuseTime = fuseTimeField.getInt(this);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (timeSinceIgnited < 0) {
                timeSinceIgnited = 0;
            }
            if (timeSinceIgnited >= fuseTime) {
                try {
                    timeSinceIgnitedField.set(this, fuseTime);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.explode();
            }
        }
        super.func_70071_h_();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(50.0);
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return ModSounds.spectrite_creeper_hurt;
    }

    protected SoundEvent func_184615_bR() {
        return ModSounds.spectrite_creeper_death;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return ModLootTables.spectrite_creeper;
    }

    private void explode() {
        if (!this.field_70170_p.field_72995_K) {
            boolean flag = this.field_70170_p.func_82736_K().func_82766_b("mobGriefing");
            float f = this.func_70830_n() ? 2.0f : 1.0f;
            this.doSpectriteDamage();
            this.field_70729_aU = true;
            this.getClass();
            Spectrite.Proxy.newSpectriteExplosion(this.field_70170_p, (Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 4.0f * f, false, flag, false);
            this.func_70106_y();
            this.spawnLingeringCloud();
        }
    }

    private void doSpectriteDamage() {
        int power = 3 + (this.func_70830_n() ? 1 : 0);
        BlockPos pos = this.func_180425_c();
        List surrounding = this.field_70170_p.func_72839_b((Entity)this, new AxisAlignedBB(pos.func_177964_d(power).func_177985_f(power).func_177979_c(power), this.func_180425_c().func_177970_e(power).func_177965_g(power).func_177981_b(power)));
        switch (power) {
            case 4: {
                this.field_70170_p.func_184133_a(null, pos, ModSounds.explosion, SoundCategory.PLAYERS, 4.75f, 0.75f + this.field_70170_p.field_73012_v.nextFloat() * 0.4f);
                this.field_70170_p.func_184133_a(null, pos, ModSounds.fatality, SoundCategory.PLAYERS, 5.0f, 0.75f);
                break;
            }
            default: {
                this.field_70170_p.func_184133_a(null, pos, ModSounds.explosion, SoundCategory.PLAYERS, 3.75f, 0.75f + this.field_70170_p.field_73012_v.nextFloat() * 0.4f);
                this.field_70170_p.func_184133_a(null, pos, ModSounds.fatality, SoundCategory.PLAYERS, 4.0f, 1.0f);
            }
        }
        for (int s = 0; s < surrounding.size(); ++s) {
            int relPower;
            if (!(surrounding.get(s) instanceof EntityLivingBase) || ((Entity)surrounding.get(s)).func_184191_r((Entity)this)) continue;
            EntityLivingBase curEntity = (EntityLivingBase)surrounding.get(s);
            double distance = curEntity.func_70032_d((Entity)this);
            int damageLevel = relPower = (int)Math.ceil((double)power - distance);
            if (!curEntity.func_184607_cu().func_190926_b() && curEntity.func_184585_cz() && curEntity.func_184607_cu().func_77973_b() instanceof ItemShield) {
                damageLevel = Math.max(relPower - (curEntity.func_184607_cu().func_77973_b() instanceof ItemSpectriteShield ? (curEntity.func_184607_cu().func_77973_b() instanceof ItemSpectriteShieldSpecial ? 2 : 1) : 0), 0);
                relPower = Math.max(relPower - (relPower - (damageLevel - 1)), 0);
                int shieldDamage = 0;
                switch (damageLevel) {
                    case 1: {
                        shieldDamage = 8;
                        break;
                    }
                    case 2: {
                        shieldDamage = 32;
                        break;
                    }
                    case 3: {
                        shieldDamage = 128;
                        break;
                    }
                    case 4: {
                        shieldDamage = 512;
                        break;
                    }
                    case 5: {
                        shieldDamage = 2048;
                    }
                }
                if (shieldDamage > 0) {
                    curEntity.func_184607_cu().func_77972_a(shieldDamage, curEntity);
                }
            }
            if (relPower < 0) continue;
            curEntity.func_70690_d(new PotionEffect(ModPotions.SPECTRITE_DAMAGE, 5, relPower));
        }
    }

    public boolean func_70601_bi() {
        BlockPos pos = new BlockPos((Entity)this);
        if (this.field_70170_p.func_180494_b(pos) != ModBiomes.spectrite_dungeon) {
            return true;
        }
        int spawnChance = pos.func_177956_o() + 8 >> 3;
        boolean shouldSpawn = spawnChance == 1 || spawnChance == 2 && this.field_70146_Z.nextBoolean() || spawnChance == 3 && this.field_70146_Z.nextInt(3) == 0;
        return shouldSpawn && pos.func_177977_b().func_177956_o() < 28;
    }

    public boolean func_184191_r(Entity entityIn) {
        return entityIn instanceof ISpectriteMob && (entityIn.getClass() != EntitySpectriteGolem.class || !((EntitySpectriteGolem)entityIn).func_70850_q()) || super.func_184191_r(entityIn);
    }

    private void spawnLingeringCloud() {
        EntitySpectriteAreaEffectCloud entitySpectriteAreaEffectCloud = new EntitySpectriteAreaEffectCloud(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.getClass();
        entitySpectriteAreaEffectCloud.setRadius(4.0f - 0.5f + (this.func_70830_n() ? 1.0f : 0.0f));
        entitySpectriteAreaEffectCloud.setRadiusOnUse(-0.5f);
        entitySpectriteAreaEffectCloud.setWaitTime(10);
        entitySpectriteAreaEffectCloud.setDuration(entitySpectriteAreaEffectCloud.getDuration() / 2);
        entitySpectriteAreaEffectCloud.setRadiusPerTick(-entitySpectriteAreaEffectCloud.getRadius() / (float)entitySpectriteAreaEffectCloud.getDuration());
        entitySpectriteAreaEffectCloud.setPotionType(this.func_70830_n() ? ModPotions.SPECTRITE_DAMAGE_IV : ModPotions.SPECTRITE_DAMAGE_V);
        entitySpectriteAreaEffectCloud.addEffect(new PotionEffect(ModPotions.SPECTRITE_DAMAGE, 25, this.func_70830_n() ? 4 : 3));
        this.field_70170_p.func_72838_d((Entity)entitySpectriteAreaEffectCloud);
    }
}

