/*
 * Decompiled with CFR 0.152.
 */
package com.samuel.spectrite.entities;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.samuel.spectrite.Spectrite;
import com.samuel.spectrite.helpers.SpectriteHelper;
import com.samuel.spectrite.init.ModPotions;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.PotionTypes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class EntitySpectriteAreaEffectCloud
extends Entity {
    private static final DataParameter<Float> RADIUS = EntityDataManager.func_187226_a(EntitySpectriteAreaEffectCloud.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Boolean> IGNORE_RADIUS = EntityDataManager.func_187226_a(EntitySpectriteAreaEffectCloud.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> HUE_OFFSET_LEVEL = EntityDataManager.func_187226_a(EntitySpectriteAreaEffectCloud.class, (DataSerializer)DataSerializers.field_187192_b);
    private PotionType potionType = PotionTypes.field_185229_a;
    private Potion potion;
    private final List<PotionEffect> effects = Lists.newArrayList();
    private final Map<Entity, Integer> reapplicationDelayMap = Maps.newHashMap();
    private int duration = 600;
    private int waitTime = 20;
    private int reapplicationDelay = 20;
    private int durationOnUse;
    private float radiusOnUse;
    private float radiusPerTick;
    private EntityLivingBase owner;
    private UUID ownerUniqueId;

    public EntitySpectriteAreaEffectCloud(World worldIn) {
        super(worldIn);
        this.field_70145_X = true;
        this.field_70178_ae = true;
        this.setRadius(3.0f);
    }

    public EntitySpectriteAreaEffectCloud(World worldIn, double x, double y, double z) {
        this(worldIn);
        this.func_70107_b(x, y, z);
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(RADIUS, (Object)Float.valueOf(0.5f));
        this.func_184212_Q().func_187214_a(IGNORE_RADIUS, (Object)false);
        this.func_184212_Q().func_187214_a(HUE_OFFSET_LEVEL, (Object)0);
    }

    public void setRadius(float radiusIn) {
        double d0 = this.field_70165_t;
        double d1 = this.field_70163_u;
        double d2 = this.field_70161_v;
        this.func_70105_a(radiusIn * 2.0f, 0.5f);
        this.func_70107_b(d0, d1, d2);
        if (!this.field_70170_p.field_72995_K) {
            this.func_184212_Q().func_187227_b(RADIUS, (Object)Float.valueOf(radiusIn));
        }
    }

    public float getRadius() {
        return ((Float)this.func_184212_Q().func_187225_a(RADIUS)).floatValue();
    }

    public void setPotionType(PotionType potionTypeIn) {
        this.potionType = potionTypeIn;
        this.potion = ((PotionEffect)this.potionType.func_185170_a().get(0)).func_188419_a();
        this.setHueOffsetLevel(ModPotions.SPECTRITE.equals(potionTypeIn) ? 0 : (ModPotions.SPECTRITE_DAMAGE.equals(this.potion) ? 1 : 2));
    }

    public void addEffect(PotionEffect effect) {
        this.effects.add(effect);
    }

    protected void setIgnoreRadius(boolean ignoreRadius) {
        this.func_184212_Q().func_187227_b(IGNORE_RADIUS, (Object)ignoreRadius);
    }

    public boolean shouldIgnoreRadius() {
        return (Boolean)this.func_184212_Q().func_187225_a(IGNORE_RADIUS);
    }

    public int getHueOffsetLevel() {
        return (Integer)this.func_184212_Q().func_187225_a(HUE_OFFSET_LEVEL);
    }

    public void setHueOffsetLevel(int hueOffsetLevel) {
        this.func_184212_Q().func_187227_b(HUE_OFFSET_LEVEL, (Object)hueOffsetLevel);
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int durationIn) {
        this.duration = durationIn;
    }

    public void func_70071_h_() {
        block20: {
            boolean flag1;
            float f;
            boolean flag;
            block18: {
                double[] colourRGB;
                float offsetLevel;
                block19: {
                    super.func_70071_h_();
                    flag = this.shouldIgnoreRadius();
                    f = this.getRadius();
                    if (!this.field_70170_p.field_72995_K) break block18;
                    offsetLevel = (float)this.getHueOffsetLevel() * 120.0f;
                    float[] colour = SpectriteHelper.getCurrentSpectriteRGBColour(offsetLevel);
                    colourRGB = new double[]{(double)colour[0] * 255.0, (double)colour[1] * 255.0, (double)colour[2] * 255.0};
                    if (!flag) break block19;
                    if (!this.field_70146_Z.nextBoolean()) break block20;
                    for (int i = 0; i < 2; ++i) {
                        float f1 = this.field_70146_Z.nextFloat() * ((float)Math.PI * 2);
                        float f2 = MathHelper.func_76129_c((float)this.field_70146_Z.nextFloat()) * 0.2f;
                        float f3 = MathHelper.func_76134_b((float)f1) * f2;
                        float f4 = MathHelper.func_76126_a((float)f1) * f2;
                        Spectrite.Proxy.spawnSpectriteSpellParticle(this.field_70170_p, this.field_70165_t + (double)f3, this.field_70163_u, this.field_70161_v + (double)f4, colourRGB[0], colourRGB[1], colourRGB[2], offsetLevel);
                    }
                    break block20;
                }
                float f5 = (float)Math.PI * f * f;
                int k1 = 0;
                while ((float)k1 < f5) {
                    float f6 = this.field_70146_Z.nextFloat() * ((float)Math.PI * 2);
                    float f7 = MathHelper.func_76129_c((float)this.field_70146_Z.nextFloat()) * f;
                    float f8 = MathHelper.func_76134_b((float)f6) * f7;
                    float f9 = MathHelper.func_76126_a((float)f6) * f7;
                    Spectrite.Proxy.spawnSpectriteSpellParticle(this.field_70170_p, this.field_70165_t + (double)f8, this.field_70163_u, this.field_70161_v + (double)f9, colourRGB[0], colourRGB[1], colourRGB[2], offsetLevel);
                    ++k1;
                }
                break block20;
            }
            if (this.field_70173_aa >= this.waitTime + this.duration) {
                this.func_70106_y();
                return;
            }
            boolean bl = flag1 = this.field_70173_aa < this.waitTime;
            if (flag != flag1) {
                this.setIgnoreRadius(flag1);
            }
            if (flag1) {
                return;
            }
            if (this.radiusPerTick != 0.0f) {
                if ((f += this.radiusPerTick) < 0.5f) {
                    this.func_70106_y();
                    return;
                }
                this.setRadius(f);
            }
            if (this.field_70173_aa % 5 == 0) {
                Iterator<Map.Entry<Entity, Integer>> iterator = this.reapplicationDelayMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<Entity, Integer> entry = iterator.next();
                    if (this.field_70173_aa < entry.getValue()) continue;
                    iterator.remove();
                }
                ArrayList potions = Lists.newArrayList();
                for (PotionEffect potioneffect1 : this.potionType.func_185170_a()) {
                    potions.add(new PotionEffect(potioneffect1.func_188419_a(), potioneffect1.func_76459_b() / 4, potioneffect1.func_76458_c(), potioneffect1.func_82720_e(), potioneffect1.func_188418_e()));
                }
                potions.addAll(this.effects);
                if (potions.isEmpty()) {
                    this.reapplicationDelayMap.clear();
                } else {
                    List list = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.func_174813_aQ());
                    if (!list.isEmpty()) {
                        for (EntityLivingBase entitylivingbase : list) {
                            double d1;
                            double d0;
                            double d2;
                            if (this.reapplicationDelayMap.containsKey(entitylivingbase) || !entitylivingbase.func_184603_cC() || !((d2 = (d0 = entitylivingbase.field_70165_t - this.field_70165_t) * d0 + (d1 = entitylivingbase.field_70161_v - this.field_70161_v) * d1) <= (double)(f * f))) continue;
                            this.reapplicationDelayMap.put((Entity)entitylivingbase, this.field_70173_aa + this.reapplicationDelay);
                            for (PotionEffect potioneffect : potions) {
                                if (potioneffect.func_188419_a().func_76403_b()) {
                                    if (potioneffect.func_188419_a() == ModPotions.SPECTRITE_DAMAGE && this.getOwner() != null && this.getOwner() == entitylivingbase) continue;
                                    potioneffect.func_188419_a().func_180793_a((Entity)this, (Entity)this.getOwner(), entitylivingbase, potioneffect.func_76458_c(), 0.5);
                                    continue;
                                }
                                entitylivingbase.func_70690_d(new PotionEffect(potioneffect));
                            }
                            if (this.radiusOnUse != 0.0f) {
                                if ((f += this.radiusOnUse) < 0.5f) {
                                    this.func_70106_y();
                                    return;
                                }
                                this.setRadius(f);
                            }
                            if (this.durationOnUse == 0) continue;
                            this.duration += this.durationOnUse;
                            if (this.duration > 0) continue;
                            this.func_70106_y();
                            return;
                        }
                    }
                }
            }
        }
    }

    public void setRadiusOnUse(float radiusOnUseIn) {
        this.radiusOnUse = radiusOnUseIn;
    }

    public void setRadiusPerTick(float radiusPerTickIn) {
        this.radiusPerTick = radiusPerTickIn;
    }

    public void setWaitTime(int waitTimeIn) {
        this.waitTime = waitTimeIn;
    }

    public void setOwner(@Nullable EntityLivingBase ownerIn) {
        this.owner = ownerIn;
        this.ownerUniqueId = ownerIn == null ? null : ownerIn.func_110124_au();
    }

    @Nullable
    public EntityLivingBase getOwner() {
        Entity entity;
        if (this.owner == null && this.ownerUniqueId != null && this.field_70170_p instanceof WorldServer && (entity = ((WorldServer)this.field_70170_p).func_175733_a(this.ownerUniqueId)) instanceof EntityLivingBase) {
            this.owner = (EntityLivingBase)entity;
        }
        return this.owner;
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.field_70173_aa = compound.func_74762_e("Age");
        this.duration = compound.func_74762_e("Duration");
        this.waitTime = compound.func_74762_e("WaitTime");
        this.reapplicationDelay = compound.func_74762_e("ReapplicationDelay");
        this.durationOnUse = compound.func_74762_e("DurationOnUse");
        this.setHueOffsetLevel(compound.func_74762_e("HueOffsetLevel"));
        this.radiusOnUse = compound.func_74760_g("RadiusOnUse");
        this.radiusPerTick = compound.func_74760_g("RadiusPerTick");
        this.setRadius(compound.func_74760_g("Radius"));
        this.ownerUniqueId = compound.func_186857_a("OwnerUUID");
        if (compound.func_150297_b("Potion", 8)) {
            this.setPotionType(PotionUtils.func_185187_c((NBTTagCompound)compound));
        }
        if (compound.func_150297_b("Effects", 9)) {
            NBTTagList nbttaglist = compound.func_150295_c("Effects", 10);
            this.effects.clear();
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                PotionEffect potioneffect = PotionEffect.func_82722_b((NBTTagCompound)nbttaglist.func_150305_b(i));
                if (potioneffect == null) continue;
                this.addEffect(potioneffect);
            }
        }
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a("Age", this.field_70173_aa);
        compound.func_74768_a("Duration", this.duration);
        compound.func_74768_a("WaitTime", this.waitTime);
        compound.func_74768_a("ReapplicationDelay", this.reapplicationDelay);
        compound.func_74768_a("DurationOnUse", this.durationOnUse);
        compound.func_74768_a("HueOffsetLevel", this.getHueOffsetLevel());
        compound.func_74776_a("RadiusOnUse", this.radiusOnUse);
        compound.func_74776_a("RadiusPerTick", this.radiusPerTick);
        compound.func_74776_a("Radius", this.getRadius());
        if (this.ownerUniqueId != null) {
            compound.func_186854_a("OwnerUUID", this.ownerUniqueId);
        }
        if (this.potionType != PotionTypes.field_185229_a && this.potionType != null) {
            compound.func_74778_a("Potion", ((ResourceLocation)PotionType.field_185176_a.func_177774_c((Object)this.potionType)).toString());
        }
        if (!this.effects.isEmpty()) {
            NBTTagList nbttaglist = new NBTTagList();
            for (PotionEffect potioneffect : this.effects) {
                nbttaglist.func_74742_a((NBTBase)potioneffect.func_82719_a(new NBTTagCompound()));
            }
            compound.func_74782_a("Effects", (NBTBase)nbttaglist);
        }
    }

    public void func_184206_a(DataParameter<?> key) {
        if (RADIUS.equals(key)) {
            this.setRadius(this.getRadius());
        }
        super.func_184206_a(key);
    }

    public EnumPushReaction func_184192_z() {
        return EnumPushReaction.IGNORE;
    }
}

