/*
 * Decompiled with CFR 0.152.
 */
package com.samuel.spectrite.entities;

import com.samuel.spectrite.entities.EntitySpectriteGolem;
import com.samuel.spectrite.entities.ISpectriteBipedMob;
import com.samuel.spectrite.entities.ISpectriteMob;
import com.samuel.spectrite.init.ModBiomes;
import com.samuel.spectrite.items.ItemSpectriteBow;
import java.lang.reflect.Field;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAttackRangedBow;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFleeSun;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIRestrictSun;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.AbstractSkeleton;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public abstract class AbstractSpectriteSkeleton
extends AbstractSkeleton
implements ISpectriteMob,
ISpectriteBipedMob {
    protected boolean hasSpectriteResistance;
    protected Integer equipmentSet;
    public static final int EQUIPMENT_BOW = 1;
    public static final int EQUIPMENT_SPECIAL_WEAPON = 2;
    public static final int EQUIPMENT_HELMET = 4;
    public static final int EQUIPMENT_CHESTPLATE = 8;
    public static final int EQUIPMENT_LEGGINGS = 16;
    public static final int EQUIPMENT_BOOTS = 32;
    public static final int[] EQUIPMENT_TYPES = new int[]{1, 2, 4, 8, 16, 32};
    protected final EntityAIAttackRangedBow field_85037_d = new EntityAIAttackRangedBow((EntityMob)this, 1.0, 20, 15.0f){
        private Field entity;
        {
            this.entity = null;
        }

        protected boolean func_188498_f() {
            if (this.entity == null) {
                this.entity = ObfuscationReflectionHelper.findField(EntityAIAttackRangedBow.class, (String)"field_188499_a");
            }
            try {
                AbstractSkeleton entityInstance = (AbstractSkeleton)this.entity.get((Object)this);
                return !entityInstance.func_184614_ca().func_190926_b() && entityInstance.func_184614_ca().func_77973_b() instanceof ItemBow;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
    };

    public AbstractSpectriteSkeleton(World worldIn) {
        super(worldIn);
        this.setHasSpectriteResistance(this.isArmorFullEnhanced());
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIRestrictSun((EntityCreature)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIFleeSun((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 10.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityIronGolem.class, true));
    }

    public void func_85036_m() {
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            ItemStack itemstack = this.func_184614_ca();
            if (itemstack.func_77973_b() instanceof ItemSpectriteBow) {
                this.field_70714_bg.func_85156_a((EntityAIBase)this.field_85037_d);
                Field aiAttackOnCollide = ObfuscationReflectionHelper.findField(AbstractSkeleton.class, (String)"field_85038_e");
                try {
                    this.field_70714_bg.func_85156_a((EntityAIBase)((EntityAIAttackMelee)aiAttackOnCollide.get(this)));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                int i = 20;
                if (this.field_70170_p.func_175659_aa() != EnumDifficulty.HARD) {
                    i = 40;
                }
                this.field_85037_d.func_189428_b(i);
                this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.field_85037_d);
            } else {
                super.func_85036_m();
            }
        }
    }

    @Override
    public boolean isHasSpectriteResistance() {
        return this.hasSpectriteResistance;
    }

    @Override
    public void setHasSpectriteResistance(boolean hasSpectriteResistance) {
        this.hasSpectriteResistance = hasSpectriteResistance;
    }

    public Integer getEquipmentSet() {
        return this.equipmentSet;
    }

    public void setEquipmentSet(Integer equipmentSet) {
        this.equipmentSet = equipmentSet;
    }

    protected void func_184610_a(boolean wasRecentlyHit, int lootingModifier, DamageSource source) {
        Entity damageSourceEntity;
        super.func_184610_a(wasRecentlyHit, lootingModifier, source);
        this.func_70628_a(wasRecentlyHit, lootingModifier);
        Entity entity = damageSourceEntity = source.func_76346_g() != null ? source.func_76346_g() : source.func_76364_f();
        if (!(damageSourceEntity != null && (damageSourceEntity instanceof EntityPlayer || damageSourceEntity instanceof EntityIronGolem && ((EntityIronGolem)damageSourceEntity).func_70850_q()))) {
            lootingModifier = -1;
        }
        if (lootingModifier > -1) {
            this.func_82160_b(wasRecentlyHit, lootingModifier);
        }
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        EntityArrow entityarrow = this.func_190726_a(distanceFactor);
        double d0 = target.field_70165_t - this.field_70165_t;
        double d1 = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 3.0f) - entityarrow.field_70163_u;
        double d2 = target.field_70161_v - this.field_70161_v;
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        entityarrow.func_70186_c(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4));
        this.func_184185_a(SoundEvents.field_187866_fi, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_72838_d((Entity)entityarrow);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setHasSpectriteResistance(this.isArmorFullEnhanced());
    }

    public boolean func_70601_bi() {
        BlockPos pos = new BlockPos((Entity)this);
        if (this.field_70170_p.func_180494_b(pos) != ModBiomes.spectrite_dungeon) {
            return true;
        }
        int spawnChance = pos.func_177956_o() + 8 >> 3;
        boolean shouldSpawn = spawnChance == 1 || spawnChance == 2 && this.field_70146_Z.nextBoolean() || spawnChance == 3 && this.field_70146_Z.nextInt(3) == 0;
        return shouldSpawn && pos.func_177977_b().func_177956_o() < 28;
    }

    public boolean func_184191_r(Entity entityIn) {
        return entityIn instanceof ISpectriteMob && (entityIn.getClass() != EntitySpectriteGolem.class || !((EntitySpectriteGolem)entityIn).func_70850_q()) || super.func_184191_r(entityIn);
    }
}

