/*
 * Decompiled with CFR 0.152.
 */
package com.samuel.spectrite.client.renderer.tileentity;

import com.samuel.spectrite.helpers.SpectriteHelper;
import com.samuel.spectrite.items.ItemSpectriteSkull;
import net.minecraft.client.model.ModelSkeletonHead;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySkullRenderer;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TileEntitySpectriteWitherSkeletonSkullRenderer
extends TileEntitySkullRenderer {
    private static final ResourceLocation[][] SPECTRITE_SKULL_ENTITY_TEXTURES = new ResourceLocation[ItemSpectriteSkull.SKULL_TYPES.length][];
    private final ModelSkeletonHead skeletonHead = new ModelSkeletonHead(0, 0, 64, 32);
    private final ModelSkeletonHead witherHead = new ModelSkeletonHead(0, 0, 64, 64);

    public void func_192841_a(TileEntitySkull p_192841_1_, double p_192841_2_, double p_192841_4_, double p_192841_6_, float p_192841_8_, int p_192841_9_, float p_192841_10_) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)(p_192841_1_.func_145832_p() & 7));
        float f = p_192841_1_.func_184295_a(p_192841_8_);
        this.renderSkull((float)p_192841_2_, (float)p_192841_4_, (float)p_192841_6_, enumfacing, (float)(p_192841_1_.func_145906_b() * 360) / 16.0f, p_192841_1_.func_145904_a(), p_192841_9_, f, p_192841_1_.func_145831_w());
    }

    public void renderSkull(float x, float y, float z, EnumFacing facing, float p_188190_5_, int skullType, int destroyStage, float animateTicks, World worldIn) {
        ModelSkeletonHead modelbase;
        ModelSkeletonHead modelSkeletonHead = modelbase = skullType == 0 ? this.skeletonHead : this.witherHead;
        if (destroyStage >= 0) {
            this.func_147499_a(field_178460_a[destroyStage]);
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179094_E();
            GlStateManager.func_179139_a((double)4.0, (double)2.0, (double)1.0);
            GlStateManager.func_179109_b((float)0.0625f, (float)0.0625f, (float)0.0625f);
            GlStateManager.func_179128_n((int)5888);
        } else {
            this.func_147499_a(SPECTRITE_SKULL_ENTITY_TEXTURES[skullType][SpectriteHelper.getCurrentSpectriteFrame(worldIn)]);
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179129_p();
        if (facing == EnumFacing.UP) {
            GlStateManager.func_179109_b((float)(x + 0.5f), (float)y, (float)(z + 0.5f));
        } else {
            switch (facing) {
                case NORTH: {
                    GlStateManager.func_179109_b((float)(x + 0.5f), (float)(y + 0.25f), (float)(z + 0.74f));
                    break;
                }
                case SOUTH: {
                    GlStateManager.func_179109_b((float)(x + 0.5f), (float)(y + 0.25f), (float)(z + 0.26f));
                    p_188190_5_ = 180.0f;
                    break;
                }
                case WEST: {
                    GlStateManager.func_179109_b((float)(x + 0.74f), (float)(y + 0.25f), (float)(z + 0.5f));
                    p_188190_5_ = 270.0f;
                    break;
                }
                default: {
                    GlStateManager.func_179109_b((float)(x + 0.26f), (float)(y + 0.25f), (float)(z + 0.5f));
                    p_188190_5_ = 90.0f;
                }
            }
        }
        GlStateManager.func_179091_B();
        GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
        GlStateManager.func_179141_d();
        modelbase.func_78088_a(null, animateTicks, 0.0f, 0.0f, p_188190_5_, 0.0f, 0.0625f);
        GlStateManager.func_179121_F();
        if (destroyStage >= 0) {
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179121_F();
            GlStateManager.func_179128_n((int)5888);
        }
    }

    private static ResourceLocation[] getSpectriteResourceLocations(String skullType) {
        ResourceLocation[] resourceLocations = new ResourceLocation[36];
        for (int s = 0; s < resourceLocations.length; ++s) {
            resourceLocations[s] = new ResourceLocation(String.format("spectrite:textures/entities/spectrite_%s/%d.png", skullType, s));
        }
        return resourceLocations;
    }

    static {
        for (int t = 0; t < SPECTRITE_SKULL_ENTITY_TEXTURES.length; ++t) {
            String type = ItemSpectriteSkull.SKULL_TYPES[t];
            if (t == 1) {
                type = type + "/normal";
            } else if (t == 2) {
                type = type.replace("wither_", "wither/");
            }
            TileEntitySpectriteWitherSkeletonSkullRenderer.SPECTRITE_SKULL_ENTITY_TEXTURES[t] = TileEntitySpectriteWitherSkeletonSkullRenderer.getSpectriteResourceLocations(type);
        }
    }
}

