/*
 * Decompiled with CFR 0.152.
 */
package com.samuel.spectrite.client.renderer.tileentity;

import com.samuel.spectrite.blocks.BlockSpectriteChest;
import com.samuel.spectrite.helpers.SpectriteHelper;
import com.samuel.spectrite.tileentity.TileEntitySpectriteChest;
import net.minecraft.block.Block;
import net.minecraft.client.model.ModelChest;
import net.minecraft.client.model.ModelLargeChest;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TileEntitySpectriteChestRenderer
extends TileEntitySpecialRenderer {
    private static final ResourceLocation[] textureSpectrite = TileEntitySpectriteChestRenderer.getSpectriteResourceLocations("");
    private static final ResourceLocation[] textureDoubleSpectrite = TileEntitySpectriteChestRenderer.getSpectriteResourceLocations("_double");
    private static final ResourceLocation[] textureTrappedSpectrite = TileEntitySpectriteChestRenderer.getSpectriteResourceLocations("_trapped");
    private static final ResourceLocation[] textureDoubleTrappedSpectrite = TileEntitySpectriteChestRenderer.getSpectriteResourceLocations("_trapped_double");
    private ModelChest simpleChest = new ModelChest();
    private ModelLargeChest largeChest = new ModelLargeChest();

    public void render(TileEntitySpectriteChest tile, double x, double y_, double z, float partialTick, int breakStage) {
        int var10;
        GlStateManager.func_179126_j();
        GlStateManager.func_179143_c((int)515);
        GlStateManager.func_179132_a((boolean)true);
        if (!tile.func_145830_o()) {
            var10 = 0;
        } else {
            Block var11 = tile.func_145838_q();
            var10 = tile.func_145832_p();
            if (var11 instanceof BlockSpectriteChest && var10 == 0) {
                ((BlockSpectriteChest)var11).func_176455_e(tile.func_145831_w(), tile.func_174877_v(), tile.func_145831_w().func_180495_p(tile.func_174877_v()));
                var10 = tile.func_145832_p();
            }
            tile.func_145979_i();
        }
        if (tile.field_145992_i == null && tile.field_145991_k == null) {
            float var14;
            ModelLargeChest var15;
            int chestType = tile.getMineralChestType().ordinal();
            if (tile.field_145990_j == null && tile.field_145988_l == null) {
                var15 = this.simpleChest;
                if (breakStage >= 0) {
                    this.func_147499_a(field_178460_a[breakStage]);
                    GlStateManager.func_179128_n((int)5890);
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179152_a((float)4.0f, (float)4.0f, (float)1.0f);
                    GlStateManager.func_179109_b((float)0.0625f, (float)0.0625f, (float)0.0625f);
                    GlStateManager.func_179128_n((int)5888);
                } else {
                    ResourceLocation texture = null;
                    switch (chestType) {
                        case 0: {
                            TileEntitySpectriteChestRenderer.textureSpectrite[SpectriteHelper.getCurrentSpectriteFrame((World)tile.func_145831_w())] = new ResourceLocation(String.format("spectrite:textures/tileentities/chest_spectrite%s/%d.png", "", SpectriteHelper.getCurrentSpectriteFrame(tile.func_145831_w())));
                            texture = textureSpectrite[SpectriteHelper.getCurrentSpectriteFrame(tile.func_145831_w())];
                            break;
                        }
                        case 1: {
                            texture = textureTrappedSpectrite[SpectriteHelper.getCurrentSpectriteFrame(tile.func_145831_w())];
                        }
                    }
                    this.func_147499_a(texture);
                }
            } else {
                var15 = this.largeChest;
                ResourceLocation textureDouble = null;
                switch (chestType) {
                    case 0: {
                        textureDouble = textureDoubleSpectrite[SpectriteHelper.getCurrentSpectriteFrame(tile.func_145831_w())];
                        break;
                    }
                    case 1: {
                        textureDouble = textureDoubleTrappedSpectrite[SpectriteHelper.getCurrentSpectriteFrame(tile.func_145831_w())];
                        break;
                    }
                }
                if (breakStage >= 0) {
                    this.func_147499_a(field_178460_a[breakStage]);
                    GlStateManager.func_179128_n((int)5890);
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179152_a((float)8.0f, (float)4.0f, (float)1.0f);
                    GlStateManager.func_179109_b((float)0.0625f, (float)0.0625f, (float)0.0625f);
                    GlStateManager.func_179128_n((int)5888);
                } else {
                    this.func_147499_a(textureDouble);
                }
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179091_B();
            if (breakStage < 0) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            GlStateManager.func_179109_b((float)((float)x), (float)((float)y_ + 1.0f), (float)((float)z + 1.0f));
            GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
            GlStateManager.func_179109_b((float)0.5f, (float)0.5f, (float)0.5f);
            int var12 = 0;
            if (var10 == 2) {
                var12 = 180;
            }
            if (var10 == 3) {
                var12 = 0;
            }
            if (var10 == 4) {
                var12 = 90;
            }
            if (var10 == 5) {
                var12 = -90;
            }
            if (var10 == 2 && tile.field_145990_j != null) {
                GlStateManager.func_179109_b((float)1.0f, (float)0.0f, (float)0.0f);
            }
            if (var10 == 5 && tile.field_145988_l != null) {
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-1.0f);
            }
            GlStateManager.func_179114_b((float)var12, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
            float var13 = tile.field_145986_n + (tile.field_145989_m - tile.field_145986_n) * partialTick;
            if (tile.field_145992_i != null && (var14 = tile.field_145992_i.field_145986_n + (tile.field_145992_i.field_145989_m - tile.field_145992_i.field_145986_n) * partialTick) > var13) {
                var13 = var14;
            }
            if (tile.field_145991_k != null && (var14 = tile.field_145991_k.field_145986_n + (tile.field_145991_k.field_145989_m - tile.field_145991_k.field_145986_n) * partialTick) > var13) {
                var13 = var14;
            }
            var13 = 1.0f - var13;
            var13 = 1.0f - var13 * var13 * var13;
            var15.field_78234_a.field_78795_f = -(var13 * (float)Math.PI / 2.0f);
            var15.func_78231_a();
            GlStateManager.func_179101_C();
            GlStateManager.func_179121_F();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (breakStage >= 0) {
                GlStateManager.func_179128_n((int)5890);
                GlStateManager.func_179121_F();
                GlStateManager.func_179128_n((int)5888);
            }
        }
    }

    public void func_192841_a(TileEntity tileentity, double x, double y, double z, float partialTick, int breakStage, float partial) {
        this.render((TileEntitySpectriteChest)tileentity, x, y, z, partialTick, breakStage);
    }

    private static ResourceLocation[] getSpectriteResourceLocations(String suffix) {
        ResourceLocation[] resourceLocations = new ResourceLocation[36];
        for (int s = 0; s < resourceLocations.length; ++s) {
            resourceLocations[s] = new ResourceLocation("spectrite", String.format("textures/tileentities/chest_spectrite%s/%d.png", suffix, s));
        }
        return resourceLocations;
    }
}

