/*
 * Decompiled with CFR 0.152.
 */
package com.samuel.spectrite.client.renderer.entity;

import com.samuel.spectrite.client.model.ModelSpectriteWither;
import com.samuel.spectrite.client.renderer.entity.layers.LayerSpectriteWitherAura;
import com.samuel.spectrite.entities.EntitySpectriteWither;
import com.samuel.spectrite.helpers.SpectriteHelper;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderSpectriteWither
extends RenderLiving<EntitySpectriteWither> {
    private static final Int2ObjectMap<ResourceLocation> INVULNERABLE_SPECTRITE_WITHER_TEXTURE_RES_MAP = new Int2ObjectOpenHashMap();
    private static final Int2ObjectMap<ResourceLocation> SPECTRITE_WITHER_TEXTURE_RES_MAP = new Int2ObjectOpenHashMap();

    public RenderSpectriteWither(RenderManager renderManagerIn) {
        super(renderManagerIn, (ModelBase)new ModelSpectriteWither(0.0f), 1.0f);
        this.func_177094_a(new LayerSpectriteWitherAura(this));
    }

    protected ResourceLocation getEntityTexture(EntitySpectriteWither entity) {
        Int2ObjectMap<ResourceLocation> textureMap;
        int i = entity.getInvulTime();
        boolean invulnerable = i > 0 && (i > 80 || i / 5 % 2 != 1);
        int curFrame = SpectriteHelper.getCurrentSpectriteFrame(entity.func_130014_f_());
        Int2ObjectMap<ResourceLocation> int2ObjectMap = textureMap = invulnerable ? INVULNERABLE_SPECTRITE_WITHER_TEXTURE_RES_MAP : SPECTRITE_WITHER_TEXTURE_RES_MAP;
        ResourceLocation resourceLocation = textureMap.containsKey(curFrame) ? (ResourceLocation)textureMap.get(curFrame) : new ResourceLocation(String.format("%s:textures/entities/spectrite_wither/%s/%d.png", "spectrite", invulnerable ? "invulnerable" : "normal", curFrame));
        return resourceLocation;
    }

    protected void preRenderCallback(EntitySpectriteWither entitylivingbaseIn, float partialTickTime) {
        float f = 2.0f;
        int i = entitylivingbaseIn.getInvulTime();
        if (i > 0) {
            f -= ((float)i - partialTickTime) / 220.0f * 0.5f;
        }
        GlStateManager.func_179152_a((float)f, (float)f, (float)f);
    }
}

