/*
 * Decompiled with CFR 0.152.
 */
package com.samuel.spectrite.client.renderer.entity;

import com.samuel.spectrite.client.model.ModelSpectriteEnderman;
import com.samuel.spectrite.client.renderer.entity.layers.LayerSpectriteEndermanEyes;
import com.samuel.spectrite.client.renderer.entity.layers.LayerSpectriteEndermanHeldBlock;
import com.samuel.spectrite.entities.EntitySpectriteEnderman;
import com.samuel.spectrite.helpers.SpectriteHelper;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderSpectriteEnderman
extends RenderLiving<EntitySpectriteEnderman> {
    private static final Int2ObjectMap<ResourceLocation> SPECTRITE_ENDERMAN_TEXTURE_RES_MAP = new Int2ObjectOpenHashMap();
    private final Random rnd = new Random();

    public RenderSpectriteEnderman(RenderManager renderManagerIn) {
        super(renderManagerIn, (ModelBase)new ModelSpectriteEnderman(0.0f), 0.5f);
        this.func_177094_a(new LayerSpectriteEndermanEyes(this));
        this.func_177094_a(new LayerSpectriteEndermanHeldBlock(this));
    }

    public ModelSpectriteEnderman getMainModel() {
        return (ModelSpectriteEnderman)super.func_177087_b();
    }

    public void doRender(EntitySpectriteEnderman entity, double x, double y, double z, float entityYaw, float partialTicks) {
        IBlockState iblockstate = entity.getHeldBlockState();
        ModelSpectriteEnderman modelSpectriteEnderman = this.getMainModel();
        modelSpectriteEnderman.isCarrying = iblockstate != null;
        modelSpectriteEnderman.isAttacking = entity.isScreaming();
        if (entity.isScreaming()) {
            x += this.rnd.nextGaussian() * 0.02;
            z += this.rnd.nextGaussian() * 0.02;
        }
        super.func_76986_a((EntityLiving)entity, x, y, z, entityYaw, partialTicks);
    }

    protected ResourceLocation getEntityTexture(EntitySpectriteEnderman entity) {
        ResourceLocation resourceLocation;
        int curFrame = SpectriteHelper.getCurrentSpectriteFrame(entity.func_130014_f_());
        if (SPECTRITE_ENDERMAN_TEXTURE_RES_MAP.containsKey(curFrame)) {
            resourceLocation = (ResourceLocation)SPECTRITE_ENDERMAN_TEXTURE_RES_MAP.get(curFrame);
        } else {
            resourceLocation = new ResourceLocation(String.format("%s:textures/entities/spectrite_enderman/spectrite_enderman/%d.png", "spectrite", curFrame));
            SPECTRITE_ENDERMAN_TEXTURE_RES_MAP.put(curFrame, (Object)resourceLocation);
        }
        return resourceLocation;
    }
}

