/*
 * Decompiled with CFR 0.152.
 */
package com.samuel.spectrite.client.renderer.entity;

import com.samuel.spectrite.entities.EntitySpectriteCrystal;
import com.samuel.spectrite.helpers.SpectriteHelper;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelEnderCrystal;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderSpectriteCrystal
extends Render<EntitySpectriteCrystal> {
    private static final Int2ObjectMap<ResourceLocation> CRYSTAL_TEXTURE_RES_MAP = new Int2ObjectOpenHashMap();
    private final ModelBase modelEnderCrystal = new ModelEnderCrystal(0.0f, true);
    private final ModelBase modelEnderCrystalNoBase = new ModelEnderCrystal(0.0f, false);

    public RenderSpectriteCrystal(RenderManager renderManagerIn) {
        super(renderManagerIn);
        this.field_76989_e = 0.5f;
    }

    public void doRender(EntitySpectriteCrystal entity, double x, double y, double z, float entityYaw, float partialTicks) {
        float f = (float)entity.field_70261_a + partialTicks;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x), (float)((float)y), (float)((float)z));
        this.func_110776_a(this.getEntityTexture(entity));
        float f1 = MathHelper.func_76126_a((float)(f * 0.2f)) / 2.0f + 0.5f;
        f1 = f1 * f1 + f1;
        if (this.field_188301_f) {
            GlStateManager.func_179142_g();
            GlStateManager.func_187431_e((int)this.func_188298_c((Entity)entity));
        }
        if (entity.func_184520_k()) {
            this.modelEnderCrystal.func_78088_a((Entity)entity, 0.0f, f * 3.0f, f1 * 0.2f, 0.0f, 0.0f, 0.0625f);
        } else {
            this.modelEnderCrystalNoBase.func_78088_a((Entity)entity, 0.0f, f * 3.0f, f1 * 0.2f, 0.0f, 0.0f, 0.0625f);
        }
        if (this.field_188301_f) {
            GlStateManager.func_187417_n();
            GlStateManager.func_179119_h();
        }
        GlStateManager.func_179121_F();
        super.func_76986_a((Entity)entity, x, y, z, entityYaw, partialTicks);
    }

    protected ResourceLocation getEntityTexture(EntitySpectriteCrystal entity) {
        ResourceLocation resourceLocation;
        int curFrame = SpectriteHelper.getCurrentSpectriteFrame(entity.func_130014_f_());
        if (CRYSTAL_TEXTURE_RES_MAP.containsKey(curFrame)) {
            resourceLocation = (ResourceLocation)CRYSTAL_TEXTURE_RES_MAP.get(curFrame);
        } else {
            resourceLocation = new ResourceLocation(String.format("%s:textures/entities/spectrite_crystal/%d.png", "spectrite", curFrame));
            CRYSTAL_TEXTURE_RES_MAP.put(curFrame, (Object)resourceLocation);
        }
        return resourceLocation;
    }

    public boolean shouldRender(EntitySpectriteCrystal livingEntity, ICamera camera, double camX, double camY, double camZ) {
        return super.func_177071_a((Entity)livingEntity, camera, camX, camY, camZ);
    }
}

