/*
 * Decompiled with CFR 0.152.
 */
package com.samuel.spectrite.client.renderer.entity;

import com.samuel.spectrite.entities.EntitySpectriteArrow;
import com.samuel.spectrite.helpers.SpectriteHelper;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.minecraft.client.renderer.entity.RenderArrow;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderSpectriteArrow<T extends EntitySpectriteArrow>
extends RenderArrow<T> {
    private static final Int2ObjectMap<ResourceLocation> DIAMOND_SPECTRITE_ARROW_TEXTURE_RES_MAP = new Int2ObjectOpenHashMap();
    private static final Int2ObjectMap<ResourceLocation> SPECTRITE_ARROW_TEXTURE_RES_MAP = new Int2ObjectOpenHashMap();

    public RenderSpectriteArrow(RenderManager renderManagerIn) {
        super(renderManagerIn);
    }

    protected ResourceLocation getEntityTexture(T entity) {
        ResourceLocation resourceLocation;
        int curFrame = SpectriteHelper.getCurrentSpectriteFrame(entity.func_130014_f_());
        if (((EntitySpectriteArrow)((Object)entity)).isPerfectArrow()) {
            if (SPECTRITE_ARROW_TEXTURE_RES_MAP.containsKey(curFrame)) {
                resourceLocation = (ResourceLocation)SPECTRITE_ARROW_TEXTURE_RES_MAP.get(curFrame);
            } else {
                resourceLocation = new ResourceLocation(String.format("%s:textures/entities/spectrite_arrow_special/%d.png", "spectrite", curFrame));
                SPECTRITE_ARROW_TEXTURE_RES_MAP.put(curFrame, (Object)resourceLocation);
            }
        } else if (DIAMOND_SPECTRITE_ARROW_TEXTURE_RES_MAP.containsKey(curFrame)) {
            resourceLocation = (ResourceLocation)DIAMOND_SPECTRITE_ARROW_TEXTURE_RES_MAP.get(curFrame);
        } else {
            resourceLocation = new ResourceLocation(String.format("%s:textures/entities/spectrite_arrow/%d.png", "spectrite", curFrame));
            DIAMOND_SPECTRITE_ARROW_TEXTURE_RES_MAP.put(curFrame, (Object)resourceLocation);
        }
        return resourceLocation;
    }
}

