/*
 * Decompiled with CFR 0.152.
 */
package com.samuel.spectrite.client.model;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.samuel.spectrite.blocks.BlockMoltenSpectrite;
import com.samuel.spectrite.etc.FluidMoltenSpectrite;
import com.samuel.spectrite.init.ModBlocks;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.vecmath.Matrix4f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector4f;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

@SideOnly(value=Side.CLIENT)
public class ModelMoltenSpectrite
implements IModel {
    public static final ModelMoltenSpectrite MOLTEN_SPECTRITE = new ModelMoltenSpectrite(ModBlocks.fluid_molten_spectrite);
    private final FluidMoltenSpectrite fluid;

    public ModelMoltenSpectrite(FluidMoltenSpectrite fluid) {
        this.fluid = fluid;
    }

    public Collection<ResourceLocation> getDependencies() {
        return Collections.emptySet();
    }

    public Collection<ResourceLocation> getTextures() {
        return ImmutableSet.of((Object)this.fluid.getStill(), (Object)this.fluid.getFlowing(), (Object)this.fluid.getStillOdd(), (Object)this.fluid.getFlowingOdd());
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        ImmutableMap map = PerspectiveMapWrapper.getTransforms((IModelState)state);
        return new BakedFluid((Optional<TRSRTransformation>)state.apply(Optional.empty()), (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)map, format, this.fluid.getColor(), bakedTextureGetter.apply(this.fluid.getStill()), bakedTextureGetter.apply(this.fluid.getFlowing()), bakedTextureGetter.apply(this.fluid.getStillOdd()), bakedTextureGetter.apply(this.fluid.getFlowingOdd()), this.fluid.isGaseous(), Optional.empty());
    }

    public IModelState getDefaultState() {
        return ModelRotation.X0_Y0;
    }

    public ModelMoltenSpectrite process(ImmutableMap<String, String> customData) {
        if (!customData.containsKey((Object)"molten_spectrite_fluid")) {
            return this;
        }
        String fluidStr = (String)customData.get((Object)"molten_spectrite_fluid");
        JsonElement e = new JsonParser().parse(fluidStr);
        String fluid = e.getAsString();
        if (!FluidRegistry.isFluidRegistered((String)fluid)) {
            FMLLog.severe((String)"fluid '%s' not found", (Object[])new Object[]{fluid});
            return MOLTEN_SPECTRITE;
        }
        return new ModelMoltenSpectrite((FluidMoltenSpectrite)FluidRegistry.getFluid((String)fluid));
    }

    private static final class BakedFluid
    implements IBakedModel {
        private static final int[] x = new int[]{0, 0, 1, 1};
        private static final int[] z = new int[]{0, 1, 1, 0};
        private static final float eps = 0.001f;
        private final LoadingCache<Long, BakedFluid> modelCache = CacheBuilder.newBuilder().maximumSize(200L).build((CacheLoader)new CacheLoader<Long, BakedFluid>(){

            public BakedFluid load(Long key) throws Exception {
                boolean statePresent = (key & 1L) != 0L;
                key = key >>> 1;
                int[] cornerRound = new int[4];
                for (int i = 0; i < 4; ++i) {
                    cornerRound[i] = (int)(key & 0x3FFL);
                    key = key >>> 10;
                }
                int flowRound = (int)(key & 0x7FFL) - 1024;
                boolean isOdd = key > 2048L;
                return new BakedFluid((Optional<TRSRTransformation>)transformation, (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)transforms, format, color, isOdd ? stillOdd : still, isOdd ? flowingOdd : flowing, gas, statePresent, cornerRound, flowRound);
            }
        });
        private final Optional<TRSRTransformation> transformation;
        private final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms;
        private final VertexFormat format;
        private final int color;
        private TextureAtlasSprite still;
        private TextureAtlasSprite flowing;
        private TextureAtlasSprite stillOdd;
        private TextureAtlasSprite flowingOdd;
        private final boolean gas;
        private final EnumMap<EnumFacing, List<BakedQuad>> faceQuads;

        public BakedFluid(Optional<TRSRTransformation> transformation, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms, VertexFormat format, int color, TextureAtlasSprite still, TextureAtlasSprite flowing, TextureAtlasSprite stillOdd, TextureAtlasSprite flowingOdd, boolean gas, Optional<IExtendedBlockState> stateOption) {
            this(transformation, transforms, format, color, still, flowing, gas, stateOption.isPresent(), BakedFluid.getCorners(stateOption), BakedFluid.getFlow(stateOption));
            this.stillOdd = stillOdd;
            this.flowingOdd = flowingOdd;
        }

        private static int[] getCorners(Optional<IExtendedBlockState> stateOption) {
            int[] cornerRound = new int[]{0, 0, 0, 0};
            if (stateOption.isPresent()) {
                IExtendedBlockState state = stateOption.get();
                for (int i = 0; i < 4; ++i) {
                    Float level = (Float)state.getValue((IUnlistedProperty)BlockFluidBase.LEVEL_CORNERS[i]);
                    cornerRound[i] = Math.round((level == null ? 0.875f : level.floatValue()) * 768.0f);
                }
            }
            return cornerRound;
        }

        private static int getFlow(Optional<IExtendedBlockState> stateOption) {
            Float flow = Float.valueOf(-1000.0f);
            if (stateOption.isPresent() && (flow = (Float)stateOption.get().getValue((IUnlistedProperty)BlockFluidBase.FLOW_DIRECTION)) == null) {
                flow = Float.valueOf(-1000.0f);
            }
            int flowRound = (int)Math.round(Math.toDegrees(flow.floatValue()));
            flowRound = MathHelper.func_76125_a((int)flowRound, (int)-1000, (int)1000);
            return flowRound;
        }

        public BakedFluid(Optional<TRSRTransformation> transformation, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms, VertexFormat format, int color, TextureAtlasSprite still, TextureAtlasSprite flowing, boolean gas, boolean statePresent, int[] cornerRound, int flowRound) {
            int i;
            this.transformation = transformation;
            this.transforms = transforms;
            this.format = format;
            this.color = color;
            this.still = still;
            this.flowing = flowing;
            this.gas = gas;
            this.faceQuads = Maps.newEnumMap(EnumFacing.class);
            for (EnumFacing side : EnumFacing.values()) {
                this.faceQuads.put(side, (List<BakedQuad>)ImmutableList.of());
            }
            if (statePresent) {
                int i2;
                UnpackedBakedQuad.Builder builder;
                float[] y = new float[4];
                for (i = 0; i < 4; ++i) {
                    y[i] = gas ? 1.0f - (float)cornerRound[i] / 768.0f : (float)cornerRound[i] / 768.0f;
                }
                float flow = (float)Math.toRadians(flowRound);
                TextureAtlasSprite topSprite = flowing;
                float scale = 4.0f;
                if (flow < -17.0f) {
                    flow = 0.0f;
                    scale = 8.0f;
                    topSprite = still;
                }
                float c = MathHelper.func_76134_b((float)flow) * scale;
                float s = MathHelper.func_76126_a((float)flow) * scale;
                EnumFacing side = gas ? EnumFacing.DOWN : EnumFacing.UP;
                ImmutableList.Builder topFaceBuilder = ImmutableList.builder();
                int[] u = new int[]{12, 4, 4, 12};
                int[] v = new int[]{4, 4, 12, 12};
                for (int k = 0; k < 2; ++k) {
                    builder = new UnpackedBakedQuad.Builder(format);
                    builder.setQuadOrientation(side);
                    builder.setTexture(topSprite);
                    for (int i3 = gas ? 3 : 0; i3 != (gas ? -1 : 4); i3 += gas ? -1 : 1) {
                        int l = k * 3 + (1 - 2 * k) * i3;
                        this.putVertex(builder, side, x[l], y[l], z[l], topSprite.func_94214_a(flow == 0.0f ? (double)(8.0f + c * (float)(x[l] * 2 - 1) + s * (float)(z[l] * 2 - 1)) : (double)u[i3]), topSprite.func_94207_b(flow == 0.0f ? (double)(8.0f + c * (float)(x[(l + 1) % 4] * 2 - 1) + s * (float)(z[(l + 1) % 4] * 2 - 1)) : (double)v[i3]));
                    }
                    topFaceBuilder.add((Object)builder.build());
                }
                this.faceQuads.put(side, (List<BakedQuad>)topFaceBuilder.build());
                side = side.func_176734_d();
                builder = new UnpackedBakedQuad.Builder(format);
                builder.setQuadOrientation(side);
                builder.setTexture(still);
                for (i2 = gas ? 3 : 0; i2 != (gas ? -1 : 4); i2 += gas ? -1 : 1) {
                    this.putVertex(builder, side, z[i2], gas ? 1.0f : 0.0f, x[i2], still.func_94214_a((double)(z[i2] * 16)), still.func_94207_b((double)(x[i2] * 16)));
                }
                this.faceQuads.put(side, (List<BakedQuad>)ImmutableList.of((Object)builder.build()));
                for (i2 = 0; i2 < 4; ++i2) {
                    side = EnumFacing.func_176731_b((int)((5 - i2) % 4));
                    BakedQuad[] q = new BakedQuad[2];
                    for (int k = 0; k < 2; ++k) {
                        builder = new UnpackedBakedQuad.Builder(format);
                        builder.setQuadOrientation(side);
                        builder.setTexture(flowing);
                        for (int j = 0; j < 4; ++j) {
                            int l = k * 3 + (1 - 2 * k) * j;
                            float yl = (float)z[l] * y[(i2 + x[l]) % 4];
                            if (gas && z[l] == 0) {
                                yl = 1.0f;
                            }
                            this.putVertex(builder, side, x[(i2 + x[l]) % 4], yl, z[(i2 + x[l]) % 4], flowing.func_94214_a((double)(x[l] * 8)), flowing.func_94207_b((double)((gas ? yl : 1.0f - yl) * 8.0f)));
                        }
                        q[k] = builder.build();
                    }
                    this.faceQuads.put(side, (List<BakedQuad>)ImmutableList.of((Object)q[0], (Object)q[1]));
                }
            } else {
                UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(format);
                builder.setQuadOrientation(EnumFacing.UP);
                builder.setTexture(still);
                for (i = 0; i < 4; ++i) {
                    this.putVertex(builder, EnumFacing.UP, z[i], x[i], 0.0f, still.func_94214_a((double)(z[i] * 16)), still.func_94207_b((double)(x[i] * 16)));
                }
                this.faceQuads.put(EnumFacing.SOUTH, (List<BakedQuad>)ImmutableList.of((Object)builder.build()));
            }
        }

        private void putVertex(UnpackedBakedQuad.Builder builder, EnumFacing side, float x, float y, float z, float u, float v) {
            block6: for (int e = 0; e < this.format.func_177345_h(); ++e) {
                switch (this.format.func_177348_c(e).func_177375_c()) {
                    case POSITION: {
                        float[] data = new float[]{x - (float)side.func_176730_m().func_177958_n() * 0.001f, y, z - (float)side.func_176730_m().func_177952_p() * 0.001f, 1.0f};
                        if (this.transformation.isPresent() && this.transformation.get() != TRSRTransformation.identity()) {
                            Vector4f vec = new Vector4f(data);
                            this.transformation.get().getMatrix().transform((Tuple4f)vec);
                            vec.get(data);
                        }
                        builder.put(e, data);
                        continue block6;
                    }
                    case COLOR: {
                        builder.put(e, new float[]{(float)(this.color >> 16 & 0xFF) / 255.0f, (float)(this.color >> 8 & 0xFF) / 255.0f, (float)(this.color & 0xFF) / 255.0f, (float)(this.color >> 24 & 0xFF) / 255.0f});
                        continue block6;
                    }
                    case UV: {
                        if (this.format.func_177348_c(e).func_177369_e() == 0) {
                            builder.put(e, new float[]{u, v, 0.0f, 1.0f});
                            continue block6;
                        }
                    }
                    case NORMAL: {
                        builder.put(e, new float[]{side.func_82601_c(), side.func_96559_d(), side.func_82599_e(), 0.0f});
                        continue block6;
                    }
                    default: {
                        builder.put(e, new float[0]);
                    }
                }
            }
        }

        public boolean func_177555_b() {
            return true;
        }

        public boolean func_177556_c() {
            return false;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return this.still;
        }

        public ItemCameraTransforms func_177552_f() {
            return ItemCameraTransforms.field_178357_a;
        }

        public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
            BakedFluid model = this;
            if (state instanceof IExtendedBlockState) {
                IExtendedBlockState exState = (IExtendedBlockState)state;
                int[] cornerRound = BakedFluid.getCorners(Optional.of(exState));
                int flowRound = BakedFluid.getFlow(Optional.of(exState));
                long key = flowRound + 1024 + ((Boolean)exState.func_177229_b((IProperty)BlockMoltenSpectrite.ODD) != false ? 2048 : 0);
                for (int i = 3; i >= 0; --i) {
                    key <<= 10;
                    key |= (long)cornerRound[i];
                }
                key <<= 1;
                model = (BakedFluid)this.modelCache.getUnchecked((Object)(key |= 1L));
            }
            if (side == null) {
                return ImmutableList.of();
            }
            return model.faceQuads.get(side);
        }

        public ItemOverrideList func_188617_f() {
            return ItemOverrideList.field_188022_a;
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType type) {
            return PerspectiveMapWrapper.handlePerspective((IBakedModel)this, this.transforms, (ItemCameraTransforms.TransformType)type);
        }
    }

    public static enum FluidLoader implements ICustomModelLoader
    {
        INSTANCE;


        public void func_110549_a(IResourceManager resourceManager) {
        }

        public boolean accepts(ResourceLocation modelLocation) {
            return modelLocation.func_110624_b().equals("spectrite") && modelLocation.func_110623_a().equals("molten_spectrite");
        }

        public IModel loadModel(ResourceLocation modelLocation) {
            return MOLTEN_SPECTRITE;
        }
    }
}

