/*
 * Decompiled with CFR 0.152.
 */
package com.samuel.spectrite.client.eventhandlers;

import com.samuel.spectrite.SpectriteConfig;
import com.samuel.spectrite.client.renderer.SpectriteParticleManager;
import com.samuel.spectrite.client.sounds.SpectritePositionedMobDeathSound;
import com.samuel.spectrite.client.sounds.SpectritePositionedSound;
import com.samuel.spectrite.etc.ISpectriteTool;
import com.samuel.spectrite.items.ISpectriteItem;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockEnderChest;
import net.minecraft.block.BlockSign;
import net.minecraft.block.BlockSkull;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSound;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.PlayerControllerMP;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class SpectriteClientEventHandler
implements IResourceManagerReloadListener {
    private static Field isHittingBlock = null;
    private static Field currentBlock = null;
    private static Field blockDamageMP = null;
    private final TextureAtlasSprite[] blockDamageSprites = new TextureAtlasSprite[10];

    @SubscribeEvent
    public void onGameTick(TickEvent.ClientTickEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null || event.side.isServer()) {
            return;
        }
        SpectriteParticleManager.INSTANCE.updateParticles();
    }

    @SubscribeEvent
    public void onPlaySpectriteEntitySound(PlaySoundEvent e) {
        if (e.getName().startsWith("spectrite")) {
            PositionedSound sound = (PositionedSound)e.getSound();
            e.setResultSound((ISound)(!e.getName().endsWith(".death") ? new SpectritePositionedSound(sound) : new SpectritePositionedMobDeathSound(sound)));
        }
    }

    @SubscribeEvent
    public void onRenderBlockBreak(RenderWorldLastEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        PlayerControllerMP playerController = Minecraft.func_71410_x().field_71442_b;
        SpectriteParticleManager.INSTANCE.renderParticles(event.getPartialTicks());
        ItemStack stack = player.func_184614_ca();
        boolean hittingBlock = false;
        if (isHittingBlock == null) {
            isHittingBlock = ObfuscationReflectionHelper.findField(PlayerControllerMP.class, (String)"field_78778_j");
        }
        try {
            hittingBlock = (Boolean)isHittingBlock.get(playerController);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        if (!stack.func_190926_b() && hittingBlock && stack != null && stack.func_77973_b() instanceof ISpectriteTool && !player.func_70093_af() && player.func_184811_cZ().func_185143_a(stack.func_77973_b(), 0.0f) == 0.0f && !player.func_70093_af()) {
            if (currentBlock == null) {
                currentBlock = ObfuscationReflectionHelper.findField(PlayerControllerMP.class, (String)"field_178895_c");
            }
            BlockPos currentBlockPos = null;
            try {
                currentBlockPos = (BlockPos)currentBlock.get(playerController);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            if (currentBlockPos != null) {
                List<BlockPos> affectedPosList = ((ISpectriteTool)stack.func_77973_b()).getPlayerBreakableBlocks(stack, currentBlockPos, (EntityPlayer)player);
                affectedPosList.remove(currentBlockPos);
                this.drawBlockDamageTexture(Tessellator.func_178181_a(), Tessellator.func_178181_a().func_178180_c(), (Entity)player, event.getPartialTicks(), affectedPosList);
            }
        }
    }

    private void drawBlockDamageTexture(Tessellator tessellatorIn, BufferBuilder bufferBuilder, Entity entityIn, float partialTicks, List<BlockPos> blocks) {
        World world = entityIn.func_130014_f_();
        double d0 = entityIn.field_70142_S + (entityIn.field_70165_t - entityIn.field_70142_S) * (double)partialTicks;
        double d1 = entityIn.field_70137_T + (entityIn.field_70163_u - entityIn.field_70137_T) * (double)partialTicks;
        double d2 = entityIn.field_70136_U + (entityIn.field_70161_v - entityIn.field_70136_U) * (double)partialTicks;
        if (blockDamageMP == null) {
            blockDamageMP = ObfuscationReflectionHelper.findField(PlayerControllerMP.class, (String)"field_78770_f");
        }
        float blockDamage = -1.0f;
        try {
            blockDamage = ((Float)blockDamageMP.get(Minecraft.func_71410_x().field_71442_b)).floatValue();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        if (blockDamage >= 0.0f) {
            TextureManager renderEngine = Minecraft.func_71410_x().field_71446_o;
            int progress = (int)(blockDamage * 10.0f) - 1;
            if (progress < 0) {
                return;
            }
            renderEngine.func_110577_a(TextureMap.field_110575_b);
            GlStateManager.func_179120_a((int)774, (int)768, (int)1, (int)0);
            GlStateManager.func_179147_l();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            GlStateManager.func_179136_a((float)-3.0f, (float)-3.0f);
            GlStateManager.func_179088_q();
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            GlStateManager.func_179141_d();
            GlStateManager.func_179094_E();
            bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            bufferBuilder.func_178969_c(-d0, -d1, -d2);
            bufferBuilder.func_78914_f();
            for (BlockPos blockpos : blocks) {
                IBlockState iblockstate;
                boolean hasBreak;
                Block block = world.func_180495_p(blockpos).func_177230_c();
                TileEntity te = world.func_175625_s(blockpos);
                boolean bl = hasBreak = block instanceof BlockChest || block instanceof BlockEnderChest || block instanceof BlockSign || block instanceof BlockSkull;
                if (!hasBreak) {
                    boolean bl2 = hasBreak = te != null && te.canRenderBreaking();
                }
                if (hasBreak || (iblockstate = world.func_180495_p(blockpos)).func_177230_c().func_149688_o(iblockstate) == Material.field_151579_a) continue;
                TextureAtlasSprite textureatlassprite = this.blockDamageSprites[progress];
                BlockRendererDispatcher blockrendererdispatcher = Minecraft.func_71410_x().func_175602_ab();
                blockrendererdispatcher.func_175020_a(iblockstate, blockpos, textureatlassprite, (IBlockAccess)world);
            }
            tessellatorIn.func_78381_a();
            bufferBuilder.func_178969_c(0.0, 0.0, 0.0);
            GlStateManager.func_179118_c();
            GlStateManager.func_179136_a((float)0.0f, (float)0.0f);
            GlStateManager.func_179113_r();
            GlStateManager.func_179141_d();
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179121_F();
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onRenderTooltip(ItemTooltipEvent e) {
        if (!e.getItemStack().func_190926_b() && e.getItemStack().func_77973_b() instanceof ISpectriteItem) {
            ((ISpectriteItem)e.getItemStack().func_77973_b()).addTooltipLines(e.getItemStack(), e.getToolTip());
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onDrawBlockHighlight(DrawBlockHighlightEvent e) {
        EntityPlayer player = e.getPlayer();
        BlockPos blockpos = e.getTarget().func_178782_a();
        ItemStack playerHeldItem = player.func_184614_ca();
        if (blockpos != null && !player.func_70093_af() && playerHeldItem != null && playerHeldItem.func_77973_b() instanceof ISpectriteTool) {
            float cooldown = player.func_184811_cZ().func_185143_a(playerHeldItem.func_77973_b(), 0.0f);
            float greenValue = new Double((SpectriteConfig.items.spectriteToolCooldown - SpectriteConfig.items.spectriteToolCooldown * (double)cooldown) / SpectriteConfig.items.spectriteToolCooldown).floatValue();
            if (cooldown <= 0.25f) {
                List<BlockPos> affectedPosList = ((ISpectriteTool)playerHeldItem.func_77973_b()).getPlayerBreakableBlocks(playerHeldItem, blockpos, player);
                Iterator<BlockPos> affectedPosIterator = affectedPosList.iterator();
                if (affectedPosIterator.hasNext()) {
                    do {
                        BlockPos curPos = affectedPosIterator.next();
                        if (cooldown > 0.0f) {
                            this.drawColoredBlockSelectionBox(player, curPos, e.getTarget(), e.getPartialTicks(), 0.0f, greenValue, 0.0f, 0.5f - (!curPos.equals((Object)blockpos) ? cooldown * 2.0f : 0.0f));
                            continue;
                        }
                        this.drawColoredBlockSelectionBox(player, curPos, e.getTarget(), e.getPartialTicks(), 0.0f, 1.0f, 0.0f, 0.5f);
                    } while (affectedPosIterator.hasNext());
                    e.setCanceled(true);
                }
            } else {
                this.drawColoredBlockSelectionBox(player, blockpos, e.getTarget(), e.getPartialTicks(), 0.0f, greenValue, 0.0f, 0.5f);
                e.setCanceled(true);
            }
        }
    }

    private void drawColoredBlockSelectionBox(EntityPlayer player, BlockPos blockpos, RayTraceResult rayTraceResult, float partialTicks, float r, float g, float b, float a) {
        World world = player.func_130014_f_();
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_187441_d((float)3.0f);
        GlStateManager.func_179090_x();
        GlStateManager.func_179132_a((boolean)false);
        IBlockState iblockstate = world.func_180495_p(blockpos);
        if (iblockstate.func_185904_a() != Material.field_151579_a && world.func_175723_af().func_177746_a(blockpos)) {
            double d0 = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
            double d1 = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
            double d2 = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
            RenderGlobal.func_189697_a((AxisAlignedBB)iblockstate.func_185918_c(world, blockpos).func_72317_d(-d0, -d1, -d2), (float)r, (float)g, (float)b, (float)a);
        }
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    public void func_110549_a(@Nonnull IResourceManager resourceManager) {
        TextureMap texturemap = Minecraft.func_71410_x().func_147117_R();
        for (int s = 0; s < this.blockDamageSprites.length; ++s) {
            this.blockDamageSprites[s] = texturemap.func_110572_b("minecraft:blocks/destroy_stage_" + s);
        }
    }
}

