/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.persistent;

import com.mamiyaotaru.voxelmap.MapSettingsManager;
import com.mamiyaotaru.voxelmap.interfaces.AbstractMapData;
import com.mamiyaotaru.voxelmap.interfaces.IChangeObserver;
import com.mamiyaotaru.voxelmap.interfaces.IColorManager;
import com.mamiyaotaru.voxelmap.interfaces.IPersistentMap;
import com.mamiyaotaru.voxelmap.interfaces.ISettingsAndLightingChangeNotifier;
import com.mamiyaotaru.voxelmap.interfaces.IVoxelMap;
import com.mamiyaotaru.voxelmap.persistent.CachedRegion;
import com.mamiyaotaru.voxelmap.persistent.GuiPersistentMap;
import com.mamiyaotaru.voxelmap.persistent.PersistentMapSettingsManager;
import com.mamiyaotaru.voxelmap.persistent.ThreadManager;
import com.mamiyaotaru.voxelmap.persistent.WorldMatcher;
import com.mamiyaotaru.voxelmap.util.BiomeRepository;
import com.mamiyaotaru.voxelmap.util.BlockRepository;
import com.mamiyaotaru.voxelmap.util.GameVariableAccessShim;
import com.mamiyaotaru.voxelmap.util.MutableBlockPos;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGlass;
import net.minecraft.block.BlockStainedGlass;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;

public class PersistentMap
implements IPersistentMap,
IChangeObserver {
    IVoxelMap master;
    MutableBlockPos blockPos = new MutableBlockPos(0, 0, 0);
    IColorManager colorManager;
    MapSettingsManager mapOptions;
    PersistentMapSettingsManager options;
    WorldMatcher worldMatcher;
    int[] lightmapColors;
    World world;
    String subworldName = "";
    private final int SEAFLOORLAYER = 0;
    private final int GROUNDLAYER = 1;
    private final int FOLIAGELAYER = 2;
    private final int TRANSPARENTLAYER = 3;
    private final int DRAWHEIGHT = 80;
    protected List<CachedRegion> cachedRegionsPool = Collections.synchronizedList(new ArrayList());
    protected ConcurrentHashMap<String, CachedRegion> cachedRegions = new ConcurrentHashMap(150, 0.9f, 2);
    int lastLeft = 0;
    int lastRight = 0;
    int lastTop = 0;
    int lastBottom = 0;
    CachedRegion[] lastRegionsArray = new CachedRegion[0];
    Comparator<CachedRegion> ageThenDistanceSorter = new Comparator<CachedRegion>(){

        @Override
        public int compare(CachedRegion region1, CachedRegion region2) {
            long mostRecentAccess2;
            long mostRecentAccess1 = region1.getMostRecentView();
            if (mostRecentAccess1 < (mostRecentAccess2 = region2.getMostRecentView())) {
                return 1;
            }
            if (mostRecentAccess1 > mostRecentAccess2) {
                return -1;
            }
            double distance1sq = (region1.getX() * 256 + region1.getWidth() / 2 - PersistentMap.this.options.mapX) * (region1.getX() * 256 + region1.getWidth() / 2 - PersistentMap.this.options.mapX) + (region1.getZ() * 256 + region1.getWidth() / 2 - PersistentMap.this.options.mapZ) * (region1.getZ() * 256 + region1.getWidth() / 2 - PersistentMap.this.options.mapZ);
            double distance2sq = (region2.getX() * 256 + region2.getWidth() / 2 - PersistentMap.this.options.mapX) * (region2.getX() * 256 + region2.getWidth() / 2 - PersistentMap.this.options.mapX) + (region2.getZ() * 256 + region2.getWidth() / 2 - PersistentMap.this.options.mapZ) * (region2.getZ() * 256 + region2.getWidth() / 2 - PersistentMap.this.options.mapZ);
            return Double.compare(distance1sq, distance2sq);
        }
    };
    Comparator<RegionCoordinates> distanceSorter = new Comparator<RegionCoordinates>(){

        @Override
        public int compare(RegionCoordinates coordinates1, RegionCoordinates coordinates2) {
            double distance1sq = (coordinates1.x * 256 + 128 - PersistentMap.this.options.mapX) * (coordinates1.x * 256 + 128 - PersistentMap.this.options.mapX) + (coordinates1.z * 256 + 128 - PersistentMap.this.options.mapZ) * (coordinates1.z * 256 + 128 - PersistentMap.this.options.mapZ);
            double distance2sq = (coordinates2.x * 256 + 128 - PersistentMap.this.options.mapX) * (coordinates2.x * 256 + 128 - PersistentMap.this.options.mapX) + (coordinates2.z * 256 + 128 - PersistentMap.this.options.mapZ) * (coordinates2.z * 256 + 128 - PersistentMap.this.options.mapZ);
            return Double.compare(distance1sq, distance2sq);
        }
    };

    public PersistentMap(IVoxelMap master) {
        this.master = master;
        this.colorManager = master.getColorManager();
        this.mapOptions = master.getMapOptions();
        this.options = master.getPersistentMapOptions();
        this.lightmapColors = new int[256];
        Arrays.fill(this.lightmapColors, -16777216);
    }

    @Override
    public void newWorld(World world) {
        this.purgeCachedRegions();
        this.world = world;
        if (this.worldMatcher != null) {
            this.worldMatcher.cancel();
        }
        if (world != null) {
            this.newWorldStuff();
        } else if (world == null) {
            Thread pauseForSubworldNamesThread = new Thread(null, null, "VoxelMap Pause for Subworld Name Thread"){

                @Override
                public void run() {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (PersistentMap.this.world != null) {
                        PersistentMap.this.newWorldStuff();
                    }
                }
            };
            pauseForSubworldNamesThread.start();
        }
    }

    private void newWorldStuff() {
        if (this.master.getWaypointManager().isMultiworld() && !Minecraft.func_71410_x().func_71387_A() && !this.master.getWaypointManager().receivedAutoSubworldName()) {
            this.worldMatcher = new WorldMatcher(this.master, this, this.world);
            this.worldMatcher.findMatch();
        }
    }

    @Override
    public void onTick(Minecraft mc) {
        if (mc.field_71462_r == null) {
            this.options.mapX = GameVariableAccessShim.xCoord();
            this.options.mapZ = GameVariableAccessShim.zCoord();
        }
        if (!this.master.getWaypointManager().getCurrentSubworldDescriptor(false).equals(this.subworldName)) {
            this.subworldName = this.master.getWaypointManager().getCurrentSubworldDescriptor(false);
            if (this.worldMatcher != null && !this.subworldName.equals("")) {
                this.worldMatcher.cancel();
            }
            this.purgeCachedRegions();
        }
    }

    @Override
    public PersistentMapSettingsManager getOptions() {
        return this.options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purgeCachedRegions() {
        List<CachedRegion> list = this.cachedRegionsPool;
        synchronized (list) {
            for (CachedRegion cachedRegion : this.cachedRegionsPool) {
                cachedRegion.cleanup();
            }
            this.cachedRegions.clear();
            this.cachedRegionsPool.clear();
            this.getRegions(0, -1, 0, -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveCachedRegions() {
        List<CachedRegion> list = this.cachedRegionsPool;
        synchronized (list) {
            for (CachedRegion cachedRegion : this.cachedRegionsPool) {
                cachedRegion.save();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renameSubworld(String oldName, String newName) {
        List<CachedRegion> list = this.cachedRegionsPool;
        synchronized (list) {
            for (CachedRegion cachedRegion : this.cachedRegionsPool) {
                cachedRegion.renameSubworld(oldName, newName);
            }
        }
    }

    @Override
    public ISettingsAndLightingChangeNotifier getSettingsAndLightingChangeNotifier() {
        return this.master.getSettingsAndLightingChangeNotifier();
    }

    @Override
    public void setLightMapArray(int[] lightmapColors) {
        boolean changed = false;
        int torchOffset = 0;
        int skylightMultiplier = 16;
        for (int t = 0; t < 16; ++t) {
            if (lightmapColors[t * skylightMultiplier + torchOffset] == this.lightmapColors[t * skylightMultiplier + torchOffset]) continue;
            changed = true;
        }
        this.lightmapColors = lightmapColors;
        if (changed) {
            this.getSettingsAndLightingChangeNotifier().notifyOfChanges();
        }
    }

    @Override
    public void getAndStoreData(AbstractMapData mapData, World world, Chunk chunk, MutableBlockPos blockPos, boolean underground, int startX, int startZ, int imageX, int imageY) {
        int light;
        blockPos = blockPos.withXYZ(startX + imageX, 0, startZ + imageY);
        IBlockState blockState = null;
        int biomeID = 0;
        biomeID = !chunk.func_76621_g() ? Biome.func_185362_a((Biome)chunk.func_177411_a((BlockPos)blockPos, world.field_73011_w.func_177499_m())) : -1;
        mapData.setBiomeID(imageX, imageY, biomeID);
        if (biomeID == -1) {
            return;
        }
        int surfaceHeight = 0;
        boolean solid = false;
        surfaceHeight = this.getBlockHeight(underground, chunk, blockPos, startX + imageX, startZ + imageY);
        blockState = chunk.func_177435_g((BlockPos)blockPos.withXYZ(startX + imageX, surfaceHeight, startZ + imageY));
        if (blockState.func_185904_a() != Material.field_151597_y) {
            blockState = chunk.func_177435_g((BlockPos)blockPos.withXYZ(startX + imageX, surfaceHeight - 1, startZ + imageY));
        }
        blockState = blockState.func_185899_b((IBlockAccess)world, (BlockPos)blockPos);
        mapData.setHeight(imageX, imageY, surfaceHeight);
        mapData.setBlockstate(imageX, imageY, blockState);
        if (surfaceHeight == -1) {
            surfaceHeight = 80;
            solid = true;
        }
        if (blockState.func_185904_a() == Material.field_151587_i) {
            solid = false;
        }
        int n = light = solid ? 0 : 255;
        if (!solid) {
            light = this.getLight(blockState, chunk, blockPos, startX + imageX, startZ + imageY, surfaceHeight, solid);
            mapData.setLight(imageX, imageY, light);
        }
        int seafloorHeight = 0;
        int seafloorLight = 0;
        int underwaterTransparentHeight = 0;
        Material material = blockState.func_185904_a();
        if (material == Material.field_151586_h || material == Material.field_151588_w) {
            int[] underwaterHeights = this.getSeafloorHeight(chunk, blockPos, startX + imageX, startZ + imageY, surfaceHeight);
            seafloorHeight = underwaterHeights[0];
            underwaterTransparentHeight = underwaterHeights[1];
            blockPos.setXYZ(startX + imageX, seafloorHeight - 1, startZ + imageY);
            blockState = chunk.func_177435_g((BlockPos)blockPos);
            if (blockState.func_185904_a() == Material.field_151586_h) {
                blockState = BlockRepository.air.func_176223_P();
            }
        }
        if (blockState != BlockRepository.air.func_176223_P()) {
            blockState = blockState.func_185899_b((IBlockAccess)world, (BlockPos)blockPos);
            seafloorLight = 255;
            seafloorLight = this.getLight(blockState, chunk, blockPos, startX + imageX, startZ + imageY, seafloorHeight, solid);
        }
        mapData.setOceanFloorHeight(imageX, imageY, seafloorHeight);
        mapData.setOceanFloorBlockstate(imageX, imageY, blockState);
        mapData.setOceanFloorLight(imageX, imageY, seafloorLight);
        int transparentHeight = 0;
        int transparentLight = 0;
        transparentHeight = this.getTransparentHeight(underground, chunk, blockPos, startX + imageX, startZ + imageY, surfaceHeight);
        if (transparentHeight == 0 && underwaterTransparentHeight > 0) {
            transparentHeight = underwaterTransparentHeight;
        }
        if (transparentHeight != 0) {
            blockPos.setXYZ(startX + imageX, transparentHeight - 1, startZ + imageY);
            blockState = chunk.func_177435_g((BlockPos)blockPos);
        } else {
            blockState = BlockRepository.air.func_176223_P();
        }
        if (blockState != BlockRepository.air.func_176223_P()) {
            blockState = blockState.func_185899_b((IBlockAccess)world, (BlockPos)blockPos);
            transparentLight = 255;
            transparentLight = this.getLight(blockState, chunk, blockPos, startX + imageX, startZ + imageY, transparentHeight, solid);
        }
        mapData.setTransparentHeight(imageX, imageY, transparentHeight);
        mapData.setTransparentBlockstate(imageX, imageY, blockState);
        mapData.setTransparentLight(imageX, imageY, transparentLight);
        int foliageHeight = 0;
        int foliageLight = 0;
        IBlockState foliageBlockState = null;
        if (transparentHeight != surfaceHeight + 1 && !solid) {
            foliageHeight = surfaceHeight + 1;
            blockPos.setXYZ(startX + imageX, foliageHeight - 1, startZ + imageY);
            foliageBlockState = chunk.func_177435_g((BlockPos)blockPos);
            material = foliageBlockState.func_185904_a();
            if (material == Material.field_151597_y || material == Material.field_151579_a || material == Material.field_151587_i) {
                foliageHeight = 0;
            }
            if (foliageBlockState == blockState) {
                foliageHeight = 0;
            }
        }
        if (foliageHeight == 0 && !solid && seafloorHeight > 0 && transparentHeight != seafloorHeight + 1) {
            foliageHeight = seafloorHeight + 1;
            blockPos.setXYZ(startX + imageX, foliageHeight - 1, startZ + imageY);
            foliageBlockState = chunk.func_177435_g((BlockPos)blockPos);
            material = foliageBlockState.func_185904_a();
            if (material == Material.field_151579_a || material == Material.field_151587_i || material == Material.field_151586_h || material == Material.field_151588_w) {
                foliageHeight = 0;
            }
            if (foliageBlockState == blockState) {
                foliageHeight = 0;
            }
        }
        if ((blockState = foliageHeight != 0 ? foliageBlockState : BlockRepository.air.func_176223_P()) != BlockRepository.air.func_176223_P()) {
            blockState = blockState.func_185899_b((IBlockAccess)world, (BlockPos)blockPos);
            foliageLight = 255;
            foliageLight = this.getLight(blockState, chunk, blockPos, startX + imageX, startZ + imageY, foliageHeight, solid);
        }
        mapData.setFoliageHeight(imageX, imageY, foliageHeight);
        mapData.setFoliageBlockstate(imageX, imageY, blockState);
        mapData.setFoliageLight(imageX, imageY, foliageLight);
    }

    private final int getBlockHeight(boolean underground, Chunk chunk, MutableBlockPos blockPos, int x, int z) {
        int playerHeight = 80;
        blockPos.setXYZ(x, playerHeight, z);
        int height = chunk.func_177433_f((BlockPos)blockPos);
        if (!underground) {
            IBlockState blockState;
            int transHeight = chunk.func_177440_h((BlockPos)blockPos).func_177956_o();
            if (transHeight != height && (blockState = chunk.func_177435_g((BlockPos)blockPos.withXYZ(x, transHeight - 1, z))).func_185904_a() == Material.field_151587_i) {
                height = transHeight;
            }
            return height;
        }
        int y = playerHeight;
        blockPos.setXYZ(x, y, z);
        IBlockState blockState = chunk.func_177435_g((BlockPos)blockPos);
        if (blockState.func_185891_c() == 0 && blockState.func_185904_a() != Material.field_151587_i) {
            while (y > 0) {
                blockPos.setXYZ(x, --y, z);
                blockState = chunk.func_177435_g((BlockPos)blockPos);
                if (blockState.func_185891_c() <= 0 && blockState.func_185904_a() != Material.field_151587_i) continue;
                return y + 1;
            }
            return y;
        }
        while (y <= playerHeight + 10) {
            blockPos.setXYZ(x, ++y, z);
            blockState = chunk.func_177435_g((BlockPos)blockPos);
            if (blockState.func_185891_c() != 0 || blockState.func_185904_a() == Material.field_151587_i) continue;
            return y;
        }
        return -1;
    }

    private final int[] getSeafloorHeight(Chunk chunk, MutableBlockPos blockPos, int x, int z, int height) {
        int seafloorHeight = height;
        int underwaterTransparentHeight = -1;
        IBlockState blockState = chunk.func_177435_g((BlockPos)blockPos.withXYZ(x, seafloorHeight - 1, z));
        while (blockState.func_185891_c() < 5 && blockState.func_185904_a() != Material.field_151584_j && seafloorHeight > 1) {
            if (!(blockState = chunk.func_177435_g((BlockPos)blockPos.withXYZ(x, --seafloorHeight - 1, z))).func_185904_a().func_76230_c() || blockState.func_185904_a() == Material.field_151588_w || underwaterTransparentHeight != -1) continue;
            underwaterTransparentHeight = seafloorHeight;
        }
        return new int[]{seafloorHeight, underwaterTransparentHeight};
    }

    private final int getTransparentHeight(boolean underground, Chunk chunk, MutableBlockPos blockPos, int x, int z, int height) {
        int transHeight = 0;
        if (underground) {
            transHeight = 0;
        } else {
            transHeight = chunk.func_177440_h((BlockPos)blockPos.withXYZ(x, height, z)).func_177956_o();
            if (transHeight <= height) {
                transHeight = 0;
            }
        }
        IBlockState blockState = this.world.func_180495_p((BlockPos)blockPos.withXYZ(x, transHeight - 1, z));
        Material material = blockState.func_185904_a();
        if (transHeight == height + 1 && material == Material.field_151597_y) {
            transHeight = -1;
        }
        if (material == Material.field_175972_I && (material = (blockState = this.world.func_180495_p((BlockPos)blockPos.withXYZ(x, ++transHeight - 1, z))).func_185904_a()) == Material.field_151579_a) {
            transHeight = -1;
        }
        return transHeight;
    }

    private int getLight(IBlockState blockState, Chunk chunk, MutableBlockPos blockPos, int x, int z, int height, boolean solid) {
        int i3 = 255;
        if (solid) {
            i3 = 0;
        } else if (blockState.func_177230_c() != BlockRepository.air) {
            blockPos.setXYZ(x, Math.max(Math.min(height, 255), 0), z);
            int blockLight = chunk.func_177413_a(EnumSkyBlock.BLOCK, (BlockPos)blockPos) & 0xF;
            int skyLight = chunk.func_177413_a(EnumSkyBlock.SKY, (BlockPos)blockPos);
            if (blockState.func_185904_a() == Material.field_151587_i && blockLight < 14) {
                blockLight = 14;
            }
            i3 = blockLight + skyLight * 16;
        }
        return i3;
    }

    @Override
    public int getPixelColor(AbstractMapData mapData, World world, MutableBlockPos blockPos, MutableBlockPos loopBlockPos, boolean underground, int multi, int startX, int startZ, int imageX, int imageY) {
        Material material;
        int mcX = startX + imageX;
        int mcZ = startZ + imageY;
        int surfaceHeight = 0;
        int seafloorHeight = -1;
        int transparentHeight = -1;
        int foliageHeight = -1;
        int surfaceColor = 0;
        int seafloorColor = 0;
        int transparentColor = 0;
        int foliageColor = 0;
        blockPos = blockPos.withXYZ(mcX, 0, mcZ);
        IBlockState blockState = null;
        int color24 = 0;
        int biomeID = mapData.getBiomeID(imageX, imageY);
        blockState = mapData.getBlockstate(imageX, imageY);
        if (blockState == null || blockState.func_177230_c() == BlockRepository.air && mapData.getLight(imageX, imageY) == 0 && mapData.getHeight(imageX, imageY) == 0 || biomeID == -1 || biomeID == 255) {
            return 0;
        }
        int n = this.mapOptions.biomeOverlay;
        this.mapOptions.getClass();
        if (n == 1) {
            color24 = biomeID >= 0 ? BiomeRepository.getBiomeColor(biomeID) | 0xFF000000 : 0;
            color24 = this.doSlimeAndGrid(color24, mcX, mcZ);
            return color24;
        }
        boolean solid = false;
        int blockStateID = 0;
        surfaceHeight = mapData.getHeight(imageX, imageY);
        blockStateID = BlockRepository.getStateId(blockState);
        if (surfaceHeight == -1 || surfaceHeight == 255) {
            surfaceHeight = 80;
            solid = true;
        }
        blockPos.setXYZ(mcX, surfaceHeight - 1, mcZ);
        if (blockState.func_185904_a() == Material.field_151587_i) {
            solid = false;
        }
        if (this.mapOptions.biomes) {
            surfaceColor = this.colorManager.getBlockColor(blockPos, blockStateID, biomeID);
            int tint = -1;
            tint = this.colorManager.getBiomeTint(mapData, world, blockState, blockStateID, blockPos, loopBlockPos, startX, startZ);
            if (tint != -1) {
                surfaceColor = this.colorManager.colorMultiplier(surfaceColor, tint);
            }
        } else {
            surfaceColor = this.colorManager.getBlockColorWithDefaultTint(blockPos, blockStateID);
        }
        surfaceColor = this.applyHeight(mapData, surfaceColor, underground, multi, imageX, imageY, surfaceHeight, solid, 1);
        int light = mapData.getLight(imageX, imageY);
        if (solid) {
            surfaceColor = 0;
        } else if (this.mapOptions.lightmap) {
            int lightValue = this.getLight(light);
            surfaceColor = this.colorManager.colorMultiplier(surfaceColor, lightValue);
        }
        if (this.mapOptions.waterTransparency && !solid && ((material = blockState.func_185904_a()) == Material.field_151586_h || material == Material.field_151588_w)) {
            seafloorHeight = mapData.getOceanFloorHeight(imageX, imageY);
            blockPos.setXYZ(mcX, seafloorHeight - 1, mcZ);
            blockState = mapData.getOceanFloorBlockstate(imageX, imageY);
            seafloorColor = 0;
            if (blockState != null && blockState != BlockRepository.air.func_176223_P()) {
                blockStateID = BlockRepository.getStateId(blockState);
                if (this.mapOptions.biomes) {
                    seafloorColor = this.colorManager.getBlockColor(blockPos, blockStateID, biomeID);
                    int tint = -1;
                    tint = this.colorManager.getBiomeTint(mapData, world, blockState, blockStateID, blockPos, loopBlockPos, startX, startZ);
                    if (tint != -1) {
                        seafloorColor = this.colorManager.colorMultiplier(seafloorColor, tint);
                    }
                } else {
                    seafloorColor = this.colorManager.getBlockColorWithDefaultTint(blockPos, blockStateID);
                }
                seafloorColor = this.applyHeight(mapData, seafloorColor, underground, multi, imageX, imageY, seafloorHeight, solid, 0);
                int seafloorLight = 255;
                seafloorLight = mapData.getOceanFloorLight(imageX, imageY);
                if (this.mapOptions.lightmap) {
                    int lightValue = this.getLight(seafloorLight);
                    seafloorColor = this.colorManager.colorMultiplier(seafloorColor, lightValue);
                }
            }
        }
        if (this.mapOptions.blockTransparency && !solid) {
            int lightValue;
            int tint;
            transparentHeight = -1;
            transparentHeight = mapData.getTransparentHeight(imageX, imageY);
            blockPos.setXYZ(mcX, transparentHeight - 1, mcZ);
            blockState = mapData.getTransparentBlockstate(imageX, imageY);
            transparentColor = 0;
            if (blockState != null && blockState != BlockRepository.air.func_176223_P()) {
                blockStateID = BlockRepository.getStateId(blockState);
                if (this.mapOptions.biomes) {
                    transparentColor = this.colorManager.getBlockColor(blockPos, blockStateID, biomeID);
                    tint = -1;
                    tint = this.colorManager.getBiomeTint(mapData, world, blockState, blockStateID, blockPos, loopBlockPos, startX, startZ);
                    if (tint != -1) {
                        transparentColor = this.colorManager.colorMultiplier(transparentColor, tint);
                    }
                } else {
                    transparentColor = this.colorManager.getBlockColorWithDefaultTint(blockPos, blockStateID);
                }
                transparentColor = this.applyHeight(mapData, transparentColor, underground, multi, imageX, imageY, transparentHeight, solid, 3);
                int transparentLight = 255;
                transparentLight = mapData.getTransparentLight(imageX, imageY);
                if (this.mapOptions.lightmap) {
                    lightValue = this.getLight(transparentLight);
                    transparentColor = this.colorManager.colorMultiplier(transparentColor, lightValue);
                }
            }
            foliageHeight = -1;
            foliageHeight = mapData.getFoliageHeight(imageX, imageY);
            blockPos.setXYZ(mcX, foliageHeight - 1, mcZ);
            blockState = mapData.getFoliageBlockstate(imageX, imageY);
            foliageColor = 0;
            if (blockState != null && blockState != BlockRepository.air.func_176223_P()) {
                blockStateID = BlockRepository.getStateId(blockState);
                if (this.mapOptions.biomes) {
                    foliageColor = this.colorManager.getBlockColor(blockPos, blockStateID, biomeID);
                    tint = -1;
                    tint = this.colorManager.getBiomeTint(mapData, world, blockState, blockStateID, blockPos, loopBlockPos, startX, startZ);
                    if (tint != -1) {
                        foliageColor = this.colorManager.colorMultiplier(foliageColor, tint);
                    }
                } else {
                    foliageColor = this.colorManager.getBlockColorWithDefaultTint(blockPos, blockStateID);
                }
                foliageColor = this.applyHeight(mapData, foliageColor, underground, multi, imageX, imageY, foliageHeight, solid, 2);
                int foliageLight = 255;
                foliageLight = mapData.getFoliageLight(imageX, imageY);
                if (this.mapOptions.lightmap) {
                    lightValue = this.getLight(foliageLight);
                    foliageColor = this.colorManager.colorMultiplier(foliageColor, lightValue);
                }
            }
        }
        if (this.mapOptions.waterTransparency && seafloorHeight > 0) {
            color24 = seafloorColor;
            if (foliageColor != 0 && foliageHeight <= surfaceHeight) {
                color24 = this.colorManager.colorAdder(foliageColor, color24);
            }
            if (transparentColor != 0 && transparentHeight <= surfaceHeight) {
                color24 = this.colorManager.colorAdder(transparentColor, color24);
            }
            color24 = this.colorManager.colorAdder(surfaceColor, color24);
        } else {
            color24 = surfaceColor;
        }
        if (foliageColor != 0 && foliageHeight > surfaceHeight) {
            color24 = this.colorManager.colorAdder(foliageColor, color24);
        }
        if (transparentColor != 0 && transparentHeight > surfaceHeight) {
            color24 = this.colorManager.colorAdder(transparentColor, color24);
        }
        int n2 = this.mapOptions.biomeOverlay;
        this.mapOptions.getClass();
        if (n2 == 2) {
            int bc = 0;
            if (biomeID >= 0) {
                bc = BiomeRepository.getBiomeColor(biomeID);
            }
            bc = 0x7F000000 | bc;
            color24 = this.colorManager.colorAdder(bc, color24);
        }
        color24 = this.doSlimeAndGrid(color24, mcX, mcZ);
        return color24;
    }

    private int doSlimeAndGrid(int color24, int mcX, int mcZ) {
        if (this.mapOptions.slimeChunks && !this.master.getWorldSeed().equals("")) {
            int xPosition = mcX >> 4;
            int zPosition = mcZ >> 4;
            String seedString = this.master.getWorldSeed();
            long seed = 0L;
            try {
                seed = Long.parseLong(seedString);
            }
            catch (NumberFormatException e) {
                seed = seedString.hashCode();
            }
            Random random = new Random(seed + (long)(xPosition * xPosition * 4987142) + (long)(xPosition * 5947611) + (long)(zPosition * zPosition) * 4392871L + (long)(zPosition * 389711) ^ 0x3AD8025FL);
            if (random.nextInt(10) == 0) {
                color24 = this.colorManager.colorAdder(2097217280, color24);
            }
        }
        if (this.mapOptions.chunkGrid) {
            if (mcX % 256 == 0 || mcZ % 256 == 0) {
                color24 = this.colorManager.colorAdder(2113863680, color24);
            } else if (mcX % 16 == 0 || mcZ % 16 == 0) {
                color24 = this.colorManager.colorAdder(0x7D000000, color24);
            }
        }
        return color24;
    }

    private int applyHeight(AbstractMapData mapData, int color24, boolean underground, int multi, int imageX, int imageY, int height, boolean solid, int layer) {
        if (color24 != this.colorManager.getAirColor() && color24 != 0) {
            int heightComp = -1;
            if ((this.mapOptions.heightmap || this.mapOptions.slopemap) && !solid) {
                int diff = 0;
                double sc = 0.0;
                boolean invert = false;
                if (this.mapOptions.slopemap) {
                    Block block;
                    IBlockState transparentBlockState;
                    if (imageX > 0 && imageY < 32 * multi - 1) {
                        if (layer == 0) {
                            heightComp = mapData.getOceanFloorHeight(imageX - 1, imageY + 1);
                        }
                        if (layer == 1) {
                            heightComp = mapData.getHeight(imageX - 1, imageY + 1);
                        }
                        if (layer == 2) {
                            heightComp = height;
                        }
                        if (layer == 3 && (heightComp = mapData.getTransparentHeight(imageX - 1, imageY + 1)) == -1 && (transparentBlockState = mapData.getTransparentBlockstate(imageX, imageY)) != null && transparentBlockState != BlockRepository.air.func_176223_P() && ((block = transparentBlockState.func_177230_c()) instanceof BlockGlass || block instanceof BlockStainedGlass)) {
                            heightComp = mapData.getHeight(imageX - 1, imageY + 1);
                        }
                    } else if (imageX < 32 * multi - 1 && imageY > 0) {
                        if (layer == 0) {
                            heightComp = mapData.getOceanFloorHeight(imageX + 1, imageY - 1);
                        }
                        if (layer == 1) {
                            heightComp = mapData.getHeight(imageX + 1, imageY - 1);
                        }
                        if (layer == 2) {
                            heightComp = height;
                        }
                        if (layer == 3 && (heightComp = mapData.getTransparentHeight(imageX + 1, imageY - 1)) == -1 && (transparentBlockState = mapData.getTransparentBlockstate(imageX, imageY)) != null && transparentBlockState != BlockRepository.air.func_176223_P() && ((block = transparentBlockState.func_177230_c()) instanceof BlockGlass || block instanceof BlockStainedGlass)) {
                            heightComp = mapData.getHeight(imageX + 1, imageY - 1);
                        }
                        invert = true;
                    } else {
                        heightComp = height;
                    }
                    if (heightComp == -1) {
                        heightComp = height;
                    }
                    if ((diff = !invert ? heightComp - height : height - heightComp) != 0) {
                        sc = diff > 0 ? 1.0 : (diff < 0 ? -1.0 : 0.0);
                        sc /= 8.0;
                    }
                    if (this.mapOptions.heightmap) {
                        diff = height - 80;
                        double heightsc = Math.log10((double)Math.abs(diff) / 8.0 + 1.0) / 3.0;
                        sc = diff > 0 ? sc + heightsc : sc - heightsc;
                    }
                } else if (this.mapOptions.heightmap) {
                    diff = height - 80;
                    sc = Math.log10((double)Math.abs(diff) / 8.0 + 1.0) / 1.8;
                    if (diff < 0) {
                        sc = 0.0 - sc;
                    }
                }
                int alpha = color24 >> 24 & 0xFF;
                int r = color24 >> 16 & 0xFF;
                int g = color24 >> 8 & 0xFF;
                int b = color24 >> 0 & 0xFF;
                if (sc > 0.0) {
                    r = (int)(sc * (double)(255 - r)) + r;
                    g = (int)(sc * (double)(255 - g)) + g;
                    b = (int)(sc * (double)(255 - b)) + b;
                } else if (sc < 0.0) {
                    sc = Math.abs(sc);
                    r -= (int)(sc * (double)r);
                    g -= (int)(sc * (double)g);
                    b -= (int)(sc * (double)b);
                }
                color24 = alpha * 0x1000000 + r * 65536 + g * 256 + b;
            }
        }
        return color24;
    }

    private int getLight(int light) {
        return this.lightmapColors[light];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CachedRegion[] getRegions(int left, int right, int top, int bottom) {
        if (left == this.lastLeft && right == this.lastRight && top == this.lastTop && bottom == this.lastBottom) {
            return this.lastRegionsArray;
        }
        ThreadManager.emptyQueue();
        CachedRegion[] visibleCachedRegionsArray = new CachedRegion[(right - left + 1) * (bottom - top + 1)];
        String worldName = this.master.getWaypointManager().getCurrentWorldName();
        String subWorldName = this.master.getWaypointManager().getCurrentSubworldDescriptor(false);
        ArrayList<RegionCoordinates> regionsToDisplay = new ArrayList<RegionCoordinates>();
        for (int t = left; t <= right; ++t) {
            for (int s = top; s <= bottom; ++s) {
                RegionCoordinates regionCoordinates = new RegionCoordinates(t, s);
                regionsToDisplay.add(regionCoordinates);
            }
        }
        Collections.sort(regionsToDisplay, this.distanceSorter);
        for (RegionCoordinates regionCoordinates : regionsToDisplay) {
            CachedRegion cachedRegion;
            int x = regionCoordinates.x;
            int z = regionCoordinates.z;
            StringBuilder keyBuilder = new StringBuilder("").append(x).append(",").append(z);
            String key = keyBuilder.toString();
            ConcurrentHashMap<String, CachedRegion> concurrentHashMap = this.cachedRegions;
            synchronized (concurrentHashMap) {
                cachedRegion = this.cachedRegions.get(key);
                if (cachedRegion == null) {
                    cachedRegion = new CachedRegion(this, key, this.world, worldName, subWorldName, x, z);
                    this.cachedRegions.put(key, cachedRegion);
                    List<CachedRegion> list = this.cachedRegionsPool;
                    synchronized (list) {
                        this.cachedRegionsPool.add(cachedRegion);
                    }
                }
            }
            cachedRegion.refresh(true);
            visibleCachedRegionsArray[(z - top) * (right - left + 1) + (x - left)] = cachedRegion;
        }
        this.prunePool();
        CachedRegion[] cachedRegionArray = this.lastRegionsArray;
        synchronized (this.lastRegionsArray) {
            this.lastLeft = left;
            this.lastRight = right;
            this.lastTop = top;
            this.lastBottom = bottom;
            this.lastRegionsArray = visibleCachedRegionsArray;
            // ** MonitorExit[var9_10] (shouldn't be in output)
            return visibleCachedRegionsArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prunePool() {
        List<CachedRegion> list = this.cachedRegionsPool;
        synchronized (list) {
            Iterator<CachedRegion> iterator = this.cachedRegionsPool.iterator();
            while (iterator.hasNext()) {
                CachedRegion region = iterator.next();
                if (!region.isLoaded() || !region.isEmpty()) continue;
                this.cachedRegions.put(region.getKey(), CachedRegion.emptyRegion);
                region.cleanup();
                iterator.remove();
            }
            if (this.cachedRegionsPool.size() > this.options.cacheSize) {
                Collections.sort(this.cachedRegionsPool, this.ageThenDistanceSorter);
                List<CachedRegion> toRemove = this.cachedRegionsPool.subList(this.options.cacheSize, this.cachedRegionsPool.size());
                for (CachedRegion cachedRegion : toRemove) {
                    this.cachedRegions.remove(cachedRegion.getKey());
                    cachedRegion.cleanup();
                }
                toRemove.clear();
            }
            this.compress();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void compress() {
        List<CachedRegion> list = this.cachedRegionsPool;
        synchronized (list) {
            for (CachedRegion cachedRegion : this.cachedRegionsPool) {
                if (System.currentTimeMillis() - cachedRegion.getMostRecentChange() <= 5000L) continue;
                cachedRegion.compress();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void handleChangeInWorld(BlockPos pos1, BlockPos pos2) {
        Chunk chunk = this.world.func_175726_f(pos1);
        if (chunk == null) return;
        if (!chunk.func_177410_o()) return;
        if (chunk.func_76621_g()) {
            return;
        }
        boolean isChunk = pos2 != null;
        int regionX = (int)Math.floor((double)pos1.func_177958_n() / 256.0);
        int regionZ = (int)Math.floor((double)pos1.func_177952_p() / 256.0);
        StringBuilder keyBuilder = new StringBuilder("").append(regionX).append(",").append(regionZ);
        String key = keyBuilder.toString();
        ConcurrentHashMap<String, CachedRegion> concurrentHashMap = this.cachedRegions;
        // MONITORENTER : concurrentHashMap
        CachedRegion cachedRegion = this.cachedRegions.get(key);
        if (cachedRegion == null || cachedRegion == CachedRegion.emptyRegion) {
            String worldName = this.master.getWaypointManager().getCurrentWorldName();
            String subWorldName = this.master.getWaypointManager().getCurrentSubworldDescriptor(false);
            cachedRegion = new CachedRegion(this, key, this.world, worldName, subWorldName, regionX, regionZ);
            this.cachedRegions.put(key, cachedRegion);
            CachedRegion[] cachedRegionArray = this.cachedRegionsPool;
            // MONITORENTER : this.cachedRegionsPool
            this.cachedRegionsPool.add(cachedRegion);
            // MONITOREXIT : cachedRegionArray
            cachedRegionArray = this.lastRegionsArray;
            // MONITORENTER : this.lastRegionsArray
            if (regionX >= this.lastLeft && regionX <= this.lastRight && regionZ >= this.lastTop && regionZ <= this.lastBottom) {
                this.lastRegionsArray[(regionZ - this.lastTop) * (this.lastRight - this.lastLeft + 1) + (regionX - this.lastLeft)] = cachedRegion;
            }
            // MONITOREXIT : cachedRegionArray
        }
        // MONITOREXIT : concurrentHashMap
        if (isChunk) {
            if (Minecraft.func_71410_x().field_71462_r != null && Minecraft.func_71410_x().field_71462_r instanceof GuiPersistentMap) {
                cachedRegion.registerChangeAt(pos1.func_177958_n(), pos1.func_177952_p());
                cachedRegion.refresh(false);
            } else {
                cachedRegion.loadChunk(this.world.func_175726_f(pos1));
            }
        } else {
            cachedRegion.registerChangeAt(pos1.func_177958_n(), pos1.func_177952_p());
        }
        this.prunePool();
    }

    @Override
    public void processChunk(Chunk chunk) {
    }

    @Override
    public boolean isRegionLoaded(int blockX, int blockZ) {
        int x = (int)Math.floor((float)blockX / 256.0f);
        int z = (int)Math.floor((float)blockZ / 256.0f);
        CachedRegion cachedRegion = this.cachedRegions.get("" + x + "," + z);
        if (cachedRegion == null) {
            return false;
        }
        return cachedRegion.isLoaded();
    }

    @Override
    public boolean isGroundAt(int blockX, int blockZ) {
        int x = (int)Math.floor((float)blockX / 256.0f);
        int z = (int)Math.floor((float)blockZ / 256.0f);
        CachedRegion cachedRegion = this.cachedRegions.get("" + x + "," + z);
        if (cachedRegion == null) {
            return false;
        }
        return cachedRegion.isGroundAt(blockX, blockZ);
    }

    @Override
    public int getHeightAt(int blockX, int blockZ) {
        int x = (int)Math.floor((float)blockX / 256.0f);
        int z = (int)Math.floor((float)blockZ / 256.0f);
        CachedRegion cachedRegion = this.cachedRegions.get("" + x + "," + z);
        if (cachedRegion == null) {
            return 64;
        }
        return cachedRegion.getHeightAt(blockX, blockZ);
    }

    private class RegionCoordinates {
        int x;
        int z;

        public RegionCoordinates(int x, int z) {
            this.x = x;
            this.z = z;
        }
    }
}

