/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.persistent;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mamiyaotaru.voxelmap.interfaces.IPersistentMap;
import com.mamiyaotaru.voxelmap.interfaces.ISettingsAndLightingChangeListener;
import com.mamiyaotaru.voxelmap.interfaces.ISettingsAndLightingChangeNotifier;
import com.mamiyaotaru.voxelmap.persistent.AbstractNotifyingRunnable;
import com.mamiyaotaru.voxelmap.persistent.CompressibleGLBufferedImage;
import com.mamiyaotaru.voxelmap.persistent.CompressibleMapData;
import com.mamiyaotaru.voxelmap.persistent.EmptyCachedRegion;
import com.mamiyaotaru.voxelmap.persistent.IThreadCompleteListener;
import com.mamiyaotaru.voxelmap.persistent.ThreadManager;
import com.mamiyaotaru.voxelmap.util.BlockStateParser;
import com.mamiyaotaru.voxelmap.util.CommandUtils;
import com.mamiyaotaru.voxelmap.util.DimensionManager;
import com.mamiyaotaru.voxelmap.util.MutableBlockPos;
import com.mamiyaotaru.voxelmap.util.TextUtils;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.Future;
import java.util.concurrent.locks.ReentrantLock;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.IChunkLoader;

public class CachedRegion
implements IThreadCompleteListener,
ISettingsAndLightingChangeListener {
    public static EmptyCachedRegion emptyRegion = new EmptyCachedRegion();
    private long mostRecentView = 0L;
    private long mostRecentChange = 0L;
    private IPersistentMap persistentMap;
    private String key;
    private World world;
    private IChunkLoader chunkLoader;
    private String worldName;
    private String subworldName;
    private String worldNamePathPart;
    private String subworldNamePathPart = "";
    private String dimensionNamePathPart;
    private String dimensionNamePathPartOld;
    private boolean underground = false;
    private int x;
    private int z;
    private int width = 256;
    private boolean empty = true;
    private boolean liveChunksUpdated = false;
    boolean remoteWorld;
    private boolean[] chunkChanged = new boolean[256];
    private CompressibleGLBufferedImage image;
    private CompressibleMapData data;
    MutableBlockPos blockPos = new MutableBlockPos(0, 0, 0);
    MutableBlockPos loopBlockPos = new MutableBlockPos(0, 0, 0);
    Future<?> future = null;
    private ReentrantLock threadLock = new ReentrantLock();
    boolean displayOptionsChanged = false;
    boolean imageChanged = false;
    boolean queued = false;
    boolean refreshingImage = false;
    boolean updated = false;
    boolean updateQueued = false;
    boolean loaded = false;
    private boolean queuedToCompress = false;

    public CachedRegion() {
    }

    public CachedRegion(IPersistentMap persistentMap, String key, World world, String worldName, String subworldName, int x, int z) {
        this.persistentMap = persistentMap;
        this.key = key;
        this.world = world;
        this.worldName = worldName;
        this.subworldName = subworldName;
        this.worldNamePathPart = TextUtils.scrubNameFile(worldName);
        if (subworldName != "") {
            this.subworldNamePathPart = TextUtils.scrubNameFile(subworldName) + "/";
        }
        String dimensionName = world.field_73011_w.func_186058_p().func_186065_b();
        int dimensionID = DimensionManager.getDimensionIDfromProvider(world.field_73011_w);
        this.dimensionNamePathPartOld = TextUtils.scrubNameFile(dimensionName);
        this.dimensionNamePathPart = TextUtils.scrubNameFile(dimensionName + " (dimension " + dimensionID + ")");
        boolean knownUnderground = false;
        knownUnderground = knownUnderground || dimensionName.toLowerCase().equals("erebus");
        this.underground = !world.field_73011_w.func_76569_d() && !world.field_73011_w.func_191066_m() && dimensionID != 1 || knownUnderground;
        this.remoteWorld = !Minecraft.func_71410_x().func_71387_A();
        persistentMap.getSettingsAndLightingChangeNotifier().addObserver(this);
        this.x = x;
        this.z = z;
        if (!this.remoteWorld) {
            WorldServer worldServer = Minecraft.func_71410_x().func_71401_C().func_71218_a(dimensionID);
            this.chunkLoader = worldServer.func_72860_G().func_75763_a(worldServer.field_73011_w);
        }
        Arrays.fill(this.chunkChanged, false);
    }

    public void registerChangeAt(int worldBlockX, int worldBlockZ) {
        int blockX = worldBlockX - this.x * 256;
        int blockZ = worldBlockZ - this.z * 256;
        int chunkX = (int)Math.floor((float)blockX / 16.0f);
        int chunkZ = (int)Math.floor((float)blockZ / 16.0f);
        try {
            this.chunkChanged[chunkZ * 16 + chunkX] = true;
            this.updateQueued = true;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameSubworld(String oldName, String newName) {
        if (oldName.equals(this.subworldName)) {
            this.threadLock.lock();
            try {
                this.subworldName = newName;
                if (this.subworldName != "") {
                    this.subworldNamePathPart = TextUtils.scrubNameFile(this.subworldName) + "/";
                }
            }
            catch (Exception exception) {
            }
            finally {
                this.threadLock.unlock();
            }
        }
    }

    @Override
    public void notifyOfActionableChange(ISettingsAndLightingChangeNotifier notifier) {
        this.displayOptionsChanged = true;
    }

    public void refresh(boolean forceCompress) {
        this.mostRecentView = System.currentTimeMillis();
        if (this.future != null && (this.future.isDone() || this.future.isCancelled())) {
            this.queued = false;
        }
        if (this.queued) {
            return;
        }
        this.queued = true;
        if (!this.loaded || this.updated || this.updateQueued || this.displayOptionsChanged) {
            RefreshRunnable regionProcessingRunnable = new RefreshRunnable(forceCompress);
            this.future = ThreadManager.executorService.submit(regionProcessingRunnable);
        } else {
            this.queued = false;
        }
    }

    public void loadChunk(Chunk chunk) {
        this.mostRecentChange = this.mostRecentView = System.currentTimeMillis();
        FillChunkRunnable fillChunkRunnable = new FillChunkRunnable(chunk);
        ThreadManager.executorService.execute(fillChunkRunnable);
    }

    @Override
    public void notifyOfThreadComplete(AbstractNotifyingRunnable runnable) {
    }

    private void load() {
        this.data = new CompressibleMapData(256, 256);
        this.image = new CompressibleGLBufferedImage(256, 256, 6);
        this.loadCachedData();
        this.loadCurrentData(this.world);
        if (!this.remoteWorld) {
            this.loadAnvilData(this.world);
        }
        this.loaded = true;
    }

    private void loadCurrentData(World world) {
        for (int chunkX = 0; chunkX < 16; ++chunkX) {
            for (int chunkZ = 0; chunkZ < 16; ++chunkZ) {
                Chunk chunk = world.func_72964_e(this.x * 16 + chunkX, this.z * 16 + chunkZ);
                if (chunk == null || !chunk.func_177410_o()) continue;
                this.loadChunkData(chunk, chunkX, chunkZ);
                this.empty = false;
                this.liveChunksUpdated = true;
                this.updated = true;
            }
        }
    }

    private void loadModifiedData() {
        for (int chunkX = 0; chunkX < 16; ++chunkX) {
            for (int chunkZ = 0; chunkZ < 16; ++chunkZ) {
                Chunk chunk;
                if (!this.chunkChanged[chunkZ * 16 + chunkX] || (chunk = this.world.func_72964_e(this.x * 16 + chunkX, this.z * 16 + chunkZ)) == null || !chunk.func_177410_o()) continue;
                this.loadChunkData(chunk, chunkX, chunkZ);
                this.empty = false;
                this.liveChunksUpdated = true;
                this.updated = true;
            }
        }
    }

    private void loadAnvilData(World world) {
        if (this.remoteWorld) {
            return;
        }
        for (int t = 0; t < 16; ++t) {
            for (int s = 0; s < 16; ++s) {
                Chunk chunk;
                if (this.data.getHeight(t * 16, s * 16) > 0 || this.data.getLight(t * 16, s * 16) > 0 || (chunk = world.func_72964_e(this.x * 16 + t, this.z * 16 + s)) != null && !chunk.func_76621_g()) continue;
                try {
                    Chunk loadedChunk = this.chunkLoader.func_75815_a(world, this.x * 16 + t, this.z * 16 + s);
                    if (loadedChunk == null) continue;
                    this.loadChunkData(loadedChunk, t, s);
                    this.empty = false;
                    this.updated = true;
                    this.liveChunksUpdated = true;
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void loadCachedData() {
        try {
            File cachedRegionFileDir = new File(Minecraft.func_71410_x().field_71412_D, "/mods/VoxelMods/voxelMap/cache/" + this.worldNamePathPart + "/" + this.subworldNamePathPart + this.dimensionNamePathPart);
            cachedRegionFileDir.mkdirs();
            File cachedRegionFile = new File(cachedRegionFileDir, "/" + this.key + ".zip");
            if (cachedRegionFile.exists()) {
                ZipEntry ze;
                FileInputStream fis = new FileInputStream(cachedRegionFile);
                ZipInputStream zis = new ZipInputStream(new BufferedInputStream(fis));
                HashBiMap stateToInt = null;
                int total = 0;
                byte[] decompressedByteData = new byte[this.data.getWidth() * this.data.getHeight() * 17 * 4];
                while ((ze = zis.getNextEntry()) != null) {
                    if (ze.getName().equals("data")) {
                        int count;
                        byte[] data = new byte[2048];
                        while ((count = zis.read(data, 0, 2048)) != -1 && count + total <= this.data.getWidth() * this.data.getHeight() * 17 * 4) {
                            System.arraycopy(data, 0, decompressedByteData, total, count);
                            total += count;
                        }
                        zis.closeEntry();
                    }
                    if (!ze.getName().equals("key")) continue;
                    stateToInt = HashBiMap.create();
                    Scanner sc = new Scanner(zis);
                    while (sc.hasNextLine()) {
                        BlockStateParser.parseLine(sc.nextLine(), (BiMap<IBlockState, Integer>)stateToInt);
                    }
                    zis.closeEntry();
                }
                if (total == this.data.getWidth() * this.data.getHeight() * 17) {
                    byte[] byteData = new byte[this.data.getWidth() * this.data.getHeight() * 17];
                    System.arraycopy(decompressedByteData, 0, byteData, 0, byteData.length);
                    this.data.setData(byteData, (BiMap<IBlockState, Integer>)stateToInt);
                    this.empty = false;
                    this.updated = true;
                } else {
                    System.out.println("failed to load data from " + cachedRegionFile.getPath());
                }
                zis.close();
                fis.close();
                if (stateToInt == null) {
                    this.liveChunksUpdated = true;
                }
            }
        }
        catch (Exception e) {
            System.err.println("Failed to load region file for " + this.x + "," + this.z + " in " + this.worldNamePathPart + "/" + this.subworldNamePathPart + this.dimensionNamePathPart);
            e.printStackTrace();
        }
    }

    private void saveData() {
        if (this.liveChunksUpdated && !this.worldNamePathPart.equals("")) {
            ThreadManager.executorService.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    CachedRegion.this.threadLock.lock();
                    try {
                        BiMap<IBlockState, Integer> stateToInt = CachedRegion.this.data.getStateToInt();
                        byte[] byteArray = CachedRegion.this.data.getData();
                        int n = byteArray.length;
                        int n2 = CachedRegion.this.data.getWidth() * CachedRegion.this.data.getHeight();
                        CachedRegion.this.data;
                        if (n == n2 * 17) {
                            File cachedRegionFileDir = new File(Minecraft.func_71410_x().field_71412_D, "/mods/VoxelMods/voxelMap/cache/" + CachedRegion.this.worldNamePathPart + "/" + CachedRegion.this.subworldNamePathPart + CachedRegion.this.dimensionNamePathPart);
                            cachedRegionFileDir.mkdirs();
                            File cachedRegionFile = new File(cachedRegionFileDir, "/" + CachedRegion.this.key + ".zip");
                            FileOutputStream fos = new FileOutputStream(cachedRegionFile);
                            ZipOutputStream zos = new ZipOutputStream(fos);
                            ZipEntry ze = new ZipEntry("data");
                            ze.setSize(byteArray.length);
                            zos.putNextEntry(ze);
                            zos.write(byteArray);
                            zos.closeEntry();
                            if (stateToInt != null) {
                                Iterator iterator = stateToInt.entrySet().iterator();
                                StringBuffer stringBuffer = new StringBuffer();
                                while (iterator.hasNext()) {
                                    Map.Entry entry = (Map.Entry)iterator.next();
                                    String nextLine = entry.getValue() + " " + ((IBlockState)entry.getKey()).toString() + "\r\n";
                                    stringBuffer.append(nextLine);
                                }
                                byte[] keyByteArray = String.valueOf(stringBuffer).getBytes();
                                ze = new ZipEntry("key");
                                ze.setSize(keyByteArray.length);
                                zos.putNextEntry(ze);
                                zos.write(keyByteArray);
                                zos.closeEntry();
                            }
                            zos.close();
                            fos.close();
                        } else {
                            System.err.println("Data array wrong size: " + byteArray.length + "for " + CachedRegion.this.x + "," + CachedRegion.this.z + " in " + CachedRegion.this.worldNamePathPart + "/" + CachedRegion.this.subworldNamePathPart + CachedRegion.this.dimensionNamePathPart);
                        }
                    }
                    catch (IOException e) {
                        System.err.println("Failed to save region file for " + CachedRegion.this.x + "," + CachedRegion.this.z + " in " + CachedRegion.this.worldNamePathPart + "/" + CachedRegion.this.subworldNamePathPart + CachedRegion.this.dimensionNamePathPart);
                        e.printStackTrace();
                    }
                    finally {
                        CachedRegion.this.threadLock.unlock();
                    }
                }
            });
            this.liveChunksUpdated = false;
        }
    }

    private void loadChunkData(Chunk chunk, int chunkX, int chunkZ) {
        for (int t = 0; t < 16; ++t) {
            for (int s = 0; s < 16; ++s) {
                this.persistentMap.getAndStoreData(this.data, this.world, chunk, this.blockPos, this.underground, this.x * 256, this.z * 256, chunkX * 16 + t, chunkZ * 16 + s);
            }
        }
        this.chunkChanged[chunkZ * 16 + chunkX] = false;
    }

    private void fillImage() {
        int color24 = 0;
        for (int t = 0; t < 256; ++t) {
            for (int s = 0; s < 256; ++s) {
                color24 = this.persistentMap.getPixelColor(this.data, this.world, this.blockPos, this.loopBlockPos, this.underground, 8, this.x * 256, this.z * 256, t, s);
                this.image.setRGB(t, s, color24);
            }
        }
    }

    private void saveImage() {
        if (!this.empty) {
            File imageFileDir = new File(Minecraft.func_71410_x().field_71412_D, "/mods/VoxelMods/voxelMap/cache/" + this.worldNamePathPart + "/" + this.subworldNamePathPart + this.dimensionNamePathPart + "/images/z1");
            imageFileDir.mkdirs();
            final File imageFile = new File(imageFileDir, this.key + ".png");
            if (this.liveChunksUpdated || !imageFile.exists()) {
                ThreadManager.executorService.execute(new Runnable(){

                    @Override
                    public void run() {
                        CachedRegion.this.threadLock.lock();
                        try {
                            BufferedImage realBufferedImage = new BufferedImage(CachedRegion.this.width, CachedRegion.this.width, 6);
                            byte[] dstArray = ((DataBufferByte)realBufferedImage.getRaster().getDataBuffer()).getData();
                            System.arraycopy(CachedRegion.this.image.getData(), 0, dstArray, 0, CachedRegion.this.image.getData().length);
                            ImageIO.write((RenderedImage)realBufferedImage, "png", imageFile);
                        }
                        catch (IOException var9) {
                            var9.printStackTrace();
                        }
                        finally {
                            CachedRegion.this.threadLock.unlock();
                        }
                    }
                });
            }
        }
    }

    public long getMostRecentView() {
        return this.mostRecentView;
    }

    public long getMostRecentChange() {
        return this.mostRecentChange;
    }

    public String getKey() {
        return this.key;
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public int getWidth() {
        return this.width;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getGLID() {
        if (this.image != null) {
            if (!this.refreshingImage) {
                CompressibleGLBufferedImage compressibleGLBufferedImage = this.image;
                synchronized (compressibleGLBufferedImage) {
                    if (this.imageChanged) {
                        this.imageChanged = false;
                        this.image.write();
                    }
                }
            }
            return this.image.getIndex();
        }
        return 0;
    }

    public CompressibleMapData getMapData() {
        return this.data;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public boolean isGroundAt(int blockX, int blockZ) {
        return this.isLoaded() && this.getHeightAt(blockX, blockZ) > 0;
    }

    public int getHeightAt(int blockX, int blockZ) {
        int y;
        int x = blockX - this.x * 256;
        int z = blockZ - this.z * 256;
        int n = y = this.data == null ? 0 : this.data.getHeight(x, z);
        if (this.underground && y == 255) {
            y = CommandUtils.getSafeHeight(blockX, 64, blockZ, this.world);
        }
        return y;
    }

    public void compress() {
        if (this.data != null && !this.isCompressed() && !this.queuedToCompress) {
            this.queuedToCompress = true;
            ThreadManager.executorService.execute(new Runnable(){

                @Override
                public void run() {
                    if (CachedRegion.this.threadLock.tryLock()) {
                        try {
                            CachedRegion.this.compressData();
                        }
                        catch (Exception exception) {
                        }
                        finally {
                            CachedRegion.this.threadLock.unlock();
                        }
                    }
                    CachedRegion.this.queuedToCompress = false;
                }
            });
        }
    }

    private void compressData() {
        this.data.compress();
    }

    private boolean isCompressed() {
        return this.data.isCompressed();
    }

    public synchronized void cleanup() {
        this.queuedToCompress = true;
        if (this.future != null) {
            this.future.cancel(false);
        }
        this.persistentMap.getSettingsAndLightingChangeNotifier().removeObserver(this);
        if (this.image != null) {
            this.image.baleet();
        }
        this.saveData();
        if (this.persistentMap.getOptions().outputImages) {
            this.saveImage();
        }
    }

    public synchronized void save() {
        this.saveData();
    }

    private class FillChunkRunnable
    implements Runnable {
        private Chunk chunk;

        public FillChunkRunnable(Chunk chunk) {
            this.chunk = chunk;
        }

        @Override
        public void run() {
            CachedRegion.this.threadLock.lock();
            try {
                if (!CachedRegion.this.loaded) {
                    CachedRegion.this.load();
                }
                int chunkX = this.chunk.field_76635_g - CachedRegion.this.x * 16;
                int chunkZ = this.chunk.field_76647_h - CachedRegion.this.z * 16;
                CachedRegion.this.loadChunkData(this.chunk, chunkX, chunkZ);
                CachedRegion.this.empty = false;
                CachedRegion.this.liveChunksUpdated = true;
                CachedRegion.this.updated = true;
            }
            catch (Exception exception) {
            }
            finally {
                CachedRegion.this.threadLock.unlock();
            }
        }
    }

    private class RefreshRunnable
    extends AbstractNotifyingRunnable {
        private boolean forceCompress = false;

        public RefreshRunnable(boolean forceCompress) {
            this.forceCompress = forceCompress;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doRun() {
            CachedRegion.this.queued = false;
            CachedRegion.this.threadLock.lock();
            CachedRegion.this.mostRecentChange = System.currentTimeMillis();
            try {
                if (!CachedRegion.this.loaded) {
                    CachedRegion.this.load();
                }
                if (CachedRegion.this.updateQueued) {
                    CachedRegion.this.loadModifiedData();
                    CachedRegion.this.updateQueued = false;
                }
                while (CachedRegion.this.updated || CachedRegion.this.displayOptionsChanged) {
                    CachedRegion.this.updated = false;
                    CachedRegion.this.displayOptionsChanged = false;
                    CachedRegion.this.refreshingImage = true;
                    CompressibleGLBufferedImage compressibleGLBufferedImage = CachedRegion.this.image;
                    synchronized (compressibleGLBufferedImage) {
                        CachedRegion.this.fillImage();
                        CachedRegion.this.imageChanged = true;
                    }
                    CachedRegion.this.refreshingImage = false;
                }
                if (this.forceCompress) {
                    CachedRegion.this.compressData();
                }
            }
            catch (Exception e) {
                System.out.println("Exception loading chunk: " + e.getLocalizedMessage());
                e.printStackTrace();
            }
            finally {
                CachedRegion.this.threadLock.unlock();
            }
        }
    }
}

