/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.additionalpipes.network.message;

import buildcraft.additionalpipes.pipes.PipeBehaviorTeleport;
import buildcraft.transport.tile.TilePipeHolder;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageTelePipeUpdate
implements IMessage,
IMessageHandler<MessageTelePipeUpdate, IMessage> {
    public BlockPos position;
    int _freq;
    boolean _isPublic;
    byte _state;
    int _newData;

    public MessageTelePipeUpdate() {
    }

    public MessageTelePipeUpdate(BlockPos position, int freq, boolean isPublic, byte index) {
        this.position = position;
        this._freq = freq;
        this._isPublic = isPublic;
        this._state = index;
    }

    public void fromBytes(ByteBuf buf) {
        this.position = BlockPos.func_177969_a((long)buf.readLong());
        this._freq = buf.readInt();
        this._isPublic = buf.readBoolean();
        this._state = buf.readByte();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.position.func_177986_g());
        buf.writeInt(this._freq);
        buf.writeBoolean(this._isPublic);
        buf.writeByte((int)this._state);
    }

    public IMessage onMessage(MessageTelePipeUpdate message, MessageContext ctx) {
        TileEntity te = ctx.getServerHandler().field_147369_b.func_130014_f_().func_175625_s(message.position);
        if (te instanceof TilePipeHolder) {
            EntityPlayerMP entityPlayer = ctx.getServerHandler().field_147369_b;
            PipeBehaviorTeleport pipe = (PipeBehaviorTeleport)((TilePipeHolder)te).getPipe().getBehaviour();
            if (!PipeBehaviorTeleport.canPlayerModifyPipe((EntityPlayer)entityPlayer, pipe)) {
                entityPlayer.func_145747_a((ITextComponent)new TextComponentString("Sorry, You may not change pipe state."));
                return null;
            }
            int frequency = message._freq;
            if (frequency < 0) {
                frequency = 0;
            }
            pipe.setFrequency(frequency);
            pipe.state = message._state;
            pipe.isPublic = message._isPublic;
        }
        return null;
    }

    public String toString() {
        return "MessageTelePipeUpdate";
    }
}

