/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.additionalpipes.network.message;

import buildcraft.additionalpipes.gui.GuiJeweledPipe;
import buildcraft.additionalpipes.pipes.PipeBehaviorJeweled;
import buildcraft.additionalpipes.pipes.SideFilterData;
import buildcraft.additionalpipes.utils.NetworkUtils;
import buildcraft.transport.tile.TilePipeHolder;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageJeweledPipeOptionsClient
implements IMessage,
IMessageHandler<MessageJeweledPipeOptionsClient, IMessage> {
    BlockPos position;
    boolean[] acceptUnsorted;
    boolean[] matchNBT;
    boolean[] matchMeta;

    public MessageJeweledPipeOptionsClient() {
    }

    public MessageJeweledPipeOptionsClient(BlockPos position, SideFilterData[] sideFilters) {
        this.position = position;
        this.acceptUnsorted = new boolean[6];
        this.matchNBT = new boolean[6];
        this.matchMeta = new boolean[6];
        for (int sideNumber = 0; sideNumber < 6; ++sideNumber) {
            this.acceptUnsorted[sideNumber] = sideFilters[sideNumber].acceptsUnsortedItems();
            this.matchNBT[sideNumber] = sideFilters[sideNumber].matchNBT();
            this.matchMeta[sideNumber] = sideFilters[sideNumber].matchMetadata();
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.position = BlockPos.func_177969_a((long)buf.readLong());
        this.acceptUnsorted = NetworkUtils.readBooleanArray(buf, 6);
        this.matchNBT = NetworkUtils.readBooleanArray(buf, 6);
        this.matchMeta = NetworkUtils.readBooleanArray(buf, 6);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.position.func_177986_g());
        NetworkUtils.writeBooleanArray(buf, this.acceptUnsorted);
        NetworkUtils.writeBooleanArray(buf, this.matchNBT);
        NetworkUtils.writeBooleanArray(buf, this.matchMeta);
    }

    public IMessage onMessage(MessageJeweledPipeOptionsClient message, MessageContext ctx) {
        TileEntity te = FMLClientHandler.instance().getClient().field_71441_e.func_175625_s(message.position);
        if (te instanceof TilePipeHolder) {
            PipeBehaviorJeweled pipe = (PipeBehaviorJeweled)((TilePipeHolder)te).getPipe().getBehaviour();
            for (int sideNumber = 0; sideNumber < 6; ++sideNumber) {
                pipe.filterData[sideNumber].setAcceptUnsortedItems(message.acceptUnsorted[sideNumber]);
                pipe.filterData[sideNumber].setMatchNBT(message.matchNBT[sideNumber]);
                pipe.filterData[sideNumber].setMatchMetadata(message.matchMeta[sideNumber]);
            }
            GuiScreen currentScreen = FMLClientHandler.instance().getClient().field_71462_r;
            if (currentScreen != null && currentScreen instanceof GuiJeweledPipe) {
                ((GuiJeweledPipe)currentScreen).updateButtonsForTab();
            }
        }
        return null;
    }

    public String toString() {
        return "MessageJeweledPipe";
    }
}

