/*
 * Decompiled with CFR 0.152.
 */
package com.wurmatron.mininggoggles.common.registry;

import com.wurmatron.mininggoggles.api.IModule;
import com.wurmatron.mininggoggles.common.registry.support.AutoFeedSOLModule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatList;
import net.minecraftforge.fml.common.Loader;

public class ModuleRegistry {
    public static List<IModule> modules = new ArrayList<IModule>();
    public static HashMap<String, Integer> moduleIDCache = new HashMap();
    public static HashMap<Integer, String> moduleNameCache = new HashMap();

    public static IModule getModuleForName(String name) {
        for (IModule module : modules) {
            if (!module.getName().equals(name)) continue;
            return module;
        }
        return null;
    }

    public static int getModuleIDFromName(String name) {
        if (moduleIDCache.size() <= 0) {
            for (int index = 0; index < modules.size(); ++index) {
                moduleIDCache.put(modules.get(index).getName(), index);
            }
        }
        return moduleIDCache.getOrDefault(name, -1);
    }

    public static String getModuleNameFromID(int id) {
        if (moduleNameCache.size() <= 0) {
            for (int index = 0; index < modules.size(); ++index) {
                moduleNameCache.put(index, modules.get(index).getName());
            }
        }
        return moduleNameCache.get(id);
    }

    public static String[] getNames() {
        if (moduleIDCache.size() <= 0) {
            ModuleRegistry.getModuleIDFromName("");
        }
        return moduleIDCache.keySet().toArray(new String[0]);
    }

    public static void registerModules() {
        modules.add(new IModule(){

            @Override
            public String getName() {
                return "nightVision";
            }

            @Override
            public void onTick(EntityPlayer player, String data) {
                player.func_70690_d(new PotionEffect(Potion.func_180142_b((String)"night_vision"), 240));
            }

            @Override
            public boolean renderOnModel() {
                return true;
            }
        });
        if (Loader.isModLoaded((String)"spiceoflife")) {
            modules.add(new AutoFeedSOLModule());
        } else {
            modules.add(new IModule(){

                @Override
                public String getName() {
                    return "autoFeed";
                }

                @Override
                public void onTick(EntityPlayer player, String data) {
                    if (player.func_71024_bL().func_75121_c()) {
                        for (ItemStack stack : player.field_71071_by.field_70462_a) {
                            if (!(stack.func_77973_b() instanceof ItemFood)) continue;
                            ItemFood food = (ItemFood)stack.func_77973_b();
                            if (player.func_71024_bL().func_75116_a() + food.func_150905_g(stack) > 20) continue;
                            player.func_71024_bL().func_151686_a(food, stack);
                            player.func_71029_a(StatList.func_188057_b((Item)food));
                            if (stack.func_190916_E() > 1) {
                                stack.func_190920_e(stack.func_190916_E() - 1);
                            } else {
                                player.field_71071_by.func_184437_d(stack);
                            }
                            player.field_71071_by.func_70296_d();
                        }
                    }
                }

                @Override
                public boolean renderOnModel() {
                    return true;
                }
            });
        }
        modules.add(new IModule(){

            @Override
            public String getName() {
                return "haste";
            }

            @Override
            public void onTick(EntityPlayer player, String data) {
                player.func_70690_d(new PotionEffect(Potion.func_180142_b((String)"haste"), 240, 1));
            }

            @Override
            public boolean renderOnModel() {
                return false;
            }
        });
        modules.add(new IModule(){

            @Override
            public String getName() {
                return "movementSpeed";
            }

            @Override
            public void onTick(EntityPlayer player, String data) {
                player.func_70690_d(new PotionEffect(Potion.func_180142_b((String)"speed"), 240, 1));
            }

            @Override
            public boolean renderOnModel() {
                return false;
            }
        });
        modules.add(new IModule(){

            @Override
            public String getName() {
                return "resistance";
            }

            @Override
            public void onTick(EntityPlayer player, String data) {
                player.func_70690_d(new PotionEffect(Potion.func_180142_b((String)"resistance"), 240, 1));
            }

            @Override
            public boolean renderOnModel() {
                return true;
            }
        });
        modules.add(new IModule(){

            @Override
            public String getName() {
                return "waterBreathing";
            }

            @Override
            public void onTick(EntityPlayer player, String data) {
                player.func_70690_d(new PotionEffect(Potion.func_180142_b((String)"water_breathing"), 240, 1));
            }

            @Override
            public boolean renderOnModel() {
                return true;
            }
        });
    }
}

