/*
 * Decompiled with CFR 0.152.
 */
package com.wurmatron.mininggoggles.common.network.utils;

import com.google.common.base.Throwables;
import com.wurmatron.mininggoggles.MiningGoggles;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IThreadListener;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public abstract class CustomMessage<T extends CustomMessage<T>>
implements IMessage,
IMessageHandler<T, IMessage> {
    private static final <T extends CustomMessage<T>> void checkAndHandle(CustomMessage<T> msg, MessageContext ctx) {
        IThreadListener thread = MiningGoggles.proxy.getThreadFromCTX(ctx);
        thread.func_152344_a(() -> msg.process(MiningGoggles.proxy.getPlayer(ctx), ctx.side));
    }

    protected abstract void read(PacketBuffer var1) throws IOException;

    protected abstract void write(PacketBuffer var1) throws IOException;

    public abstract void process(EntityPlayer var1, Side var2);

    protected boolean isValidOnSide(Side side) {
        return true;
    }

    protected boolean requiresMain() {
        return true;
    }

    public void fromBytes(ByteBuf buff) {
        try {
            this.read(new PacketBuffer(buff));
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void toBytes(ByteBuf buff) {
        try {
            this.write(new PacketBuffer(buff));
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public final IMessage onMessage(T msg, MessageContext ctx) {
        if (!((CustomMessage)msg).isValidOnSide(ctx.side)) {
            throw new RuntimeException("Invalid Side " + ctx.side.name() + " for " + msg.getClass().getSimpleName());
        }
        if (((CustomMessage)msg).requiresMain()) {
            CustomMessage.checkAndHandle(msg, ctx);
        } else {
            ((CustomMessage)msg).process(MiningGoggles.proxy.getPlayer(ctx), ctx.side);
        }
        return null;
    }

    public static abstract class CustomtServerMessage<T extends CustomMessage<T>>
    extends CustomMessage<T> {
        @Override
        protected final boolean isValidOnSide(Side side) {
            return side.isServer();
        }
    }

    public static abstract class CustomClientMessage<T extends CustomMessage<T>>
    extends CustomMessage<T> {
        @Override
        protected final boolean isValidOnSide(Side side) {
            return side.isClient();
        }
    }
}

