/*
 * Decompiled with CFR 0.152.
 */
package com.wurmatron.mininggoggles.common.network.container;

import com.wurmatron.mininggoggles.common.network.container.InventoryGoggles;
import com.wurmatron.mininggoggles.common.network.container.SlotModule;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ContainerModules
extends Container {
    private static final int ARMOR_START = 8;
    private static final int ARMOR_END = 11;
    private static final int INV_START = 12;
    private static final int INV_END = 38;
    private static final int HOTBAR_START = 39;
    private static final int HOTBAR_END = 47;
    private static final EntityEquipmentSlot[] VALID_EQUIPMENT_SLOTS = new EntityEquipmentSlot[]{EntityEquipmentSlot.HEAD, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.FEET};
    private EntityPlayer player;
    private InventoryPlayer playerInventory;
    public InventoryGoggles gogglesInventory;

    public ContainerModules(EntityPlayer player, InventoryPlayer playerInventory, InventoryGoggles gogglesInventory) {
        this.player = player;
        this.playerInventory = playerInventory;
        this.gogglesInventory = gogglesInventory;
        this.addPlayerSlots();
        this.addGoggleSlots();
    }

    private void addPlayerSlots() {
        for (int k = 0; k < 4; ++k) {
            final EntityEquipmentSlot entityequipmentslot = VALID_EQUIPMENT_SLOTS[k];
            this.func_75146_a(new Slot((IInventory)this.playerInventory, 36 + (3 - k), 8, 8 + k * 18){

                public int func_75219_a() {
                    return 1;
                }

                public boolean func_75214_a(ItemStack stack) {
                    return stack.func_77973_b().isValidArmor(stack, entityequipmentslot, (Entity)ContainerModules.this.player);
                }

                public boolean func_82869_a(EntityPlayer playerIn) {
                    ItemStack itemstack = this.func_75211_c();
                    return !itemstack.func_190926_b() && !playerIn.func_184812_l_() && EnchantmentHelper.func_190938_b((ItemStack)itemstack) ? false : super.func_82869_a(playerIn);
                }

                @Nullable
                @SideOnly(value=Side.CLIENT)
                public String func_178171_c() {
                    return ItemArmor.field_94603_a[entityequipmentslot.func_188454_b()];
                }
            });
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.func_75146_a(new Slot((IInventory)this.playerInventory, i1, 8 + i1 * 18, 142));
        }
        for (int l = 0; l < 3; ++l) {
            for (int j1 = 0; j1 < 9; ++j1) {
                this.func_75146_a(new Slot((IInventory)this.playerInventory, j1 + (l + 1) * 9, 8 + j1 * 18, 84 + l * 18));
            }
        }
    }

    private void addGoggleSlots() {
        for (int index = 0; index < 8; ++index) {
            this.func_75146_a(new SlotModule(this.gogglesInventory, index, 80 + 18 * (index / 4), 8 + 18 * (index % 4)));
        }
    }

    public boolean func_75145_c(EntityPlayer player) {
        return this.gogglesInventory.func_70300_a(player);
    }

    public ItemStack func_82846_b(EntityPlayer player, int sourceSlotIndex) {
        Slot sourceSlot = (Slot)this.field_75151_b.get(sourceSlotIndex);
        if (sourceSlot == null || !sourceSlot.func_75216_d()) {
            return ItemStack.field_190927_a;
        }
        ItemStack sourceStack = sourceSlot.func_75211_c();
        ItemStack copyOfSourceStack = sourceStack.func_77946_l();
        if (sourceSlotIndex >= 12 && sourceSlotIndex < 59) {
            if (!this.func_75135_a(sourceStack, 0, 8, false)) {
                return ItemStack.field_190927_a;
            }
        } else if (sourceSlotIndex >= 0 && sourceSlotIndex < 8) {
            if (!this.func_75135_a(sourceStack, 12, 58, false)) {
                return ItemStack.field_190927_a;
            }
        } else {
            return ItemStack.field_190927_a;
        }
        if (sourceStack.func_190916_E() == 0) {
            sourceSlot.func_75215_d(ItemStack.field_190927_a);
        } else {
            sourceSlot.func_75218_e();
        }
        sourceSlot.func_190901_a(player, sourceStack);
        return copyOfSourceStack;
    }
}

