/*
 * Decompiled with CFR 0.152.
 */
package com.wurmatron.mininggoggles.common.network;

import com.wurmatron.mininggoggles.common.network.packets.OpenGuiMessage;
import com.wurmatron.mininggoggles.common.network.packets.UpdateHelmetConfig;
import com.wurmatron.mininggoggles.common.network.utils.CustomMessage;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public class NetworkHandler {
    private static final SimpleNetworkWrapper network = NetworkRegistry.INSTANCE.newSimpleChannel("mininggoggles");
    private static byte packetID = 0;

    public static void registerPackets() {
        NetworkHandler.registerMessage(OpenGuiMessage.class);
        NetworkHandler.registerMessage(UpdateHelmetConfig.class);
    }

    private static final <T extends CustomMessage<T>> void registerMessage(Class<T> clazz) {
        if (CustomMessage.CustomClientMessage.class.isAssignableFrom(clazz)) {
            byte by = packetID;
            packetID = (byte)(by + 1);
            network.registerMessage(clazz, clazz, (int)by, Side.CLIENT);
        } else if (CustomMessage.CustomtServerMessage.class.isAssignableFrom(clazz)) {
            byte by = packetID;
            packetID = (byte)(by + 1);
            network.registerMessage(clazz, clazz, (int)by, Side.SERVER);
        } else {
            network.registerMessage(clazz, clazz, (int)packetID, Side.CLIENT);
            byte by = packetID;
            packetID = (byte)(by + 1);
            network.registerMessage(clazz, clazz, (int)by, Side.SERVER);
        }
    }

    public static void sendTo(IMessage message, EntityPlayerMP player) {
        network.sendTo(message, player);
    }

    public static void sendToAll(IMessage message) {
        network.sendToAll(message);
    }

    public static void sendToAllAround(IMessage message, NetworkRegistry.TargetPoint point) {
        network.sendToAllAround(message, point);
    }

    public static void sendToAllAround(IMessage message, int dimension, double x, double y, double z, double range) {
        NetworkHandler.sendToAllAround(message, new NetworkRegistry.TargetPoint(dimension, x, y, z, range));
    }

    public static void sendToAllAround(IMessage message, EntityPlayer player, double range) {
        NetworkHandler.sendToAllAround(message, player.field_70170_p.field_73011_w.getDimension(), player.field_70165_t, player.field_70163_u, player.field_70161_v, range);
    }

    public static void sendToDimension(IMessage message, int dimensionId) {
        network.sendToDimension(message, dimensionId);
    }

    public static void sendToServer(IMessage message) {
        network.sendToServer(message);
    }
}

