/*
 * Decompiled with CFR 0.152.
 */
package com.wurmatron.mininggoggles.common.items;

import com.wurmatron.mininggoggles.api.IModule;
import com.wurmatron.mininggoggles.common.items.MiningRegistry;
import com.wurmatron.mininggoggles.common.network.NetworkHandler;
import com.wurmatron.mininggoggles.common.network.packets.OpenGuiMessage;
import com.wurmatron.mininggoggles.common.registry.ModuleRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;

public class ItemGogglesMining
extends ItemArmor {
    public static boolean armorDetection = false;

    public ItemGogglesMining(ItemArmor.ArmorMaterial material) {
        super(material, 0, EntityEquipmentSlot.HEAD);
        this.func_77637_a(CreativeTabs.field_78026_f);
        this.func_77655_b("gogglesMining");
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        super.onArmorTick(world, player, stack);
        if (world.field_72995_K) {
            armorDetection = true;
        } else if (stack != ItemStack.field_190927_a && stack.func_77942_o() && stack.func_77978_p().func_74764_b("modules") && world.func_82737_E() % 20L == 0L) {
            NBTTagList moduleNBT = stack.func_77978_p().func_150295_c("modules", 10);
            ItemStack lastModule = ItemStack.field_190927_a;
            for (int index = 0; index < 8; ++index) {
                ItemStack moduleStack = new ItemStack(moduleNBT.func_150305_b(index));
                if (moduleStack.func_190926_b() || moduleStack.func_77969_a(lastModule)) continue;
                lastModule = moduleStack;
                IModule module = ModuleRegistry.getModuleForName(ModuleRegistry.getModuleNameFromID(moduleStack.func_77952_i()));
                if (module == null) continue;
                module.onTick(player, moduleStack.func_77978_p() != null ? moduleStack.func_77978_p().toString() : "");
            }
        }
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> sub) {
        if (tab == CreativeTabs.field_78026_f) {
            try {
                IModule[] modules = new IModule[]{ModuleRegistry.getModuleForName("nightVision"), ModuleRegistry.getModuleForName("autoFeed")};
                sub.add((Object)ItemGogglesMining.create(3, modules));
                sub.add((Object)ItemGogglesMining.create(4, modules));
                sub.add((Object)ItemGogglesMining.create(6, modules));
                sub.add((Object)ItemGogglesMining.create(8, modules));
                sub.add((Object)ItemGogglesMining.create(16, modules));
                sub.add((Object)ItemGogglesMining.create(32, modules));
                sub.add((Object)ItemGogglesMining.create(64, modules));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static ItemStack create(int range, IModule[] modules) throws Exception {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("range", range);
        if (modules != null && modules.length > 0) {
            NBTTagList nbtModules = new NBTTagList();
            if (modules.length > 8) {
                throw new Exception("Too many modules, max is 8 you tried adding " + modules.length);
            }
            for (IModule module : modules) {
                ItemStack stack = new ItemStack(MiningRegistry.itemModule, 1, ModuleRegistry.getModuleIDFromName(module.getName()));
                nbtModules.func_74742_a((NBTBase)stack.func_77955_b(new NBTTagCompound()));
            }
            if (modules.length < 8) {
                int amountLeft;
                for (int index = amountLeft = 8 - modules.length; index < 8; ++index) {
                    nbtModules.func_74742_a((NBTBase)ItemStack.field_190927_a.func_77955_b(new NBTTagCompound()));
                }
            }
            nbt.func_74782_a("modules", (NBTBase)nbtModules);
        }
        NBTTagCompound filters = new NBTTagCompound();
        for (int index = 0; index < 16; ++index) {
            filters.func_74778_a("color" + index, "");
        }
        nbt.func_74782_a("filters", (NBTBase)filters);
        ItemStack stack = new ItemStack(MiningRegistry.gogglesMining, 1);
        stack.func_77982_d(nbt);
        return stack;
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tip, flag);
        if (stack.func_77942_o()) {
            if (stack.func_77978_p().func_74764_b("range")) {
                tip.add(TextFormatting.GOLD + I18n.func_74838_a((String)"tooltip.range.name") + ": " + stack.func_77978_p().func_74762_e("range"));
            }
            if (stack.func_77978_p().func_74764_b("modules")) {
                tip.add(TextFormatting.RED + I18n.func_74838_a((String)"tooltip.modules.name"));
                NBTTagCompound nbt = stack.func_77978_p().func_74775_l("modules");
                if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                    NBTTagList moduleNBT = stack.func_77978_p().func_150295_c("modules", 10);
                    ItemStack lastModule = ItemStack.field_190927_a;
                    for (int index = 0; index < 8; ++index) {
                        ItemStack moduleStack = new ItemStack(moduleNBT.func_150305_b(index));
                        if (moduleStack.func_190926_b() || moduleStack.func_77969_a(lastModule)) continue;
                        lastModule = moduleStack;
                        IModule module = ModuleRegistry.getModuleForName(ModuleRegistry.getModuleNameFromID(moduleStack.func_77952_i()));
                        tip.add(TextFormatting.LIGHT_PURPLE + I18n.func_74838_a((String)("module." + module.getName() + ".name")) + (nbt.func_74779_i(module.getName()).length() > 0 ? nbt.func_74779_i(module.getName()) : ""));
                    }
                } else {
                    tip.add(TextFormatting.GRAY + I18n.func_74838_a((String)"tooltip.holdshift.name"));
                }
            }
        }
    }

    public boolean onEntitySwing(EntityLivingBase entity, ItemStack stack) {
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54) && !entity.field_70170_p.field_72995_K) {
            NetworkHandler.sendToServer(new OpenGuiMessage(0, entity.func_180425_c()));
        }
        return super.onEntitySwing(entity, stack);
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return "mininggoggles:textures/models/" + this.getTexture(stack) + ".png";
    }

    public static int getRange(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b("range") ? stack.func_77978_p().func_74762_e("range") : 0;
    }

    public static IModule[] getModules(ItemStack stack) {
        ArrayList<IModule> modules = new ArrayList<IModule>();
        if (stack.func_77978_p().func_74764_b("modules")) {
            NBTTagList moduleNBT = stack.func_77978_p().func_150295_c("modules", 10);
            ItemStack lastModule = ItemStack.field_190927_a;
            for (int index = 0; index < 8; ++index) {
                ItemStack moduleStack = new ItemStack(moduleNBT.func_150305_b(index));
                if (moduleStack.func_190926_b() || moduleStack.func_77969_a(lastModule)) continue;
                lastModule = moduleStack;
                IModule module = ModuleRegistry.getModuleForName(ModuleRegistry.getModuleNameFromID(moduleStack.func_77952_i()));
                if (module == null) continue;
                modules.add(module);
            }
        }
        return ItemGogglesMining.sortModulesBasedOnID(modules.toArray(new IModule[0]));
    }

    private static IModule[] sortModulesBasedOnID(IModule[] modules) {
        TreeMap sortedModules = new TreeMap(Collections.reverseOrder());
        for (IModule module : modules) {
            sortedModules.put(ModuleRegistry.getModuleIDFromName(module.getName()), module);
        }
        return sortedModules.descendingMap().values().toArray(new IModule[0]);
    }

    public String getTexture(ItemStack stack) {
        IModule[] modules = ItemGogglesMining.getModules(stack);
        StringBuilder builder = new StringBuilder();
        builder.append("goggles");
        if (modules.length > 0) {
            for (IModule module : modules) {
                if (!module.renderOnModel()) continue;
                builder.append("_" + module.getName());
            }
            return builder.toString();
        }
        return "goggles_default";
    }
}

