/*
 * Decompiled with CFR 0.152.
 */
package com.wurmatron.mininggoggles.client.render;

import baubles.api.BaublesApi;
import com.wurmatron.mininggoggles.MiningGoggles;
import com.wurmatron.mininggoggles.client.render.RenderOre;
import com.wurmatron.mininggoggles.common.ConfigHandler;
import com.wurmatron.mininggoggles.common.items.ItemGogglesMining;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.OreDictionary;
import org.cliffc.high_scale_lib.NonBlockingHashMap;
import org.cliffc.high_scale_lib.NonBlockingHashSet;

public class MiningGoggleEffect {
    private static NonBlockingHashSet<RenderOre> oreTargets = new NonBlockingHashSet();
    private static NonBlockingHashSet<RenderOre> renderingOre = new NonBlockingHashSet();
    private static NonBlockingHashMap<String, Integer> filterCache = new NonBlockingHashMap();
    private static final int[] ORE_COLOR = new int[]{0xFFFFFF, 16753920, 0xFF00FF, 11393254, 0xFFFF00, 0xBFFF00, 16738740, 0x181818, 0x606060, 65535, 0xEE82EE, 255, 13468991, 32768, 0xFF0000, 0};

    @SubscribeEvent
    public void renderInWorld(RenderWorldLastEvent e) {
        if (oreTargets.size() > 0) {
            RenderOre[] ore = oreTargets.toArray(new RenderOre[0]);
            for (int index = 0; index < ConfigHandler.renderOverTime; ++index) {
                if (index >= ore.length) continue;
                renderingOre.add(ore[index]);
                oreTargets.remove(ore[index]);
            }
        }
        for (RenderOre target : renderingOre) {
            target.render(e.getPartialTicks());
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent e) {
        if (e.side == Side.CLIENT && ItemGogglesMining.armorDetection) {
            MiningGoggles.EXECUTORS.submit(() -> {
                EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
                if (player != null && player.field_70170_p != null && (double)player.field_70170_p.func_72820_D() % this.calcRangeModifier(ItemGogglesMining.getRange((ItemStack)player.field_71071_by.field_70460_b.get(3))) == 0.0) {
                    if (!this.checkArmor((EntityPlayer)player)) {
                        ItemGogglesMining.armorDetection = false;
                        return;
                    }
                    int range = ItemGogglesMining.getRange(this.getGoggles((EntityPlayer)player));
                    this.removeOutdatedEntries(player.field_70170_p, player.func_180425_c(), range);
                    Iterable blocksToTest = BlockPos.func_191532_a((int)((int)player.field_70165_t - range), (int)((int)player.field_70163_u - range), (int)((int)player.field_70161_v - range), (int)((int)player.field_70165_t + range), (int)((int)player.field_70163_u + range), (int)((int)player.field_70161_v + range));
                    for (BlockPos pos : blocksToTest) {
                        this.validatePos(player.field_70170_p, pos, (EntityPlayer)player);
                    }
                }
            });
            MiningGoggles.EXECUTORS.submit(() -> {
                EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
                if (player != null && player.field_70170_p != null && (double)player.field_70170_p.func_72820_D() % this.calcRangeModifier(ItemGogglesMining.getRange(this.getGoggles((EntityPlayer)player))) == 0.0) {
                    if (!this.checkArmor((EntityPlayer)player)) {
                        ItemGogglesMining.armorDetection = false;
                        return;
                    }
                    int range = ItemGogglesMining.getRange(this.getGoggles((EntityPlayer)player));
                    Iterable blocksToTest = BlockPos.func_191532_a((int)((int)player.field_70165_t + range), (int)((int)player.field_70163_u + range), (int)((int)player.field_70161_v + range), (int)((int)player.field_70165_t + range * 2), (int)((int)player.field_70163_u + range * 2), (int)((int)player.field_70161_v + range * 2));
                    for (BlockPos pos : blocksToTest) {
                        this.validatePos(player.field_70170_p, pos, (EntityPlayer)player);
                    }
                }
            });
        } else if (!renderingOre.isEmpty()) {
            renderingOre.clear();
        }
    }

    public ItemStack getGoggles(EntityPlayer player) {
        if (Loader.isModLoaded((String)"baubles")) {
            return BaublesApi.getBaublesHandler((EntityPlayer)player).getStackInSlot(4);
        }
        return (ItemStack)player.field_71071_by.field_70460_b.get(3);
    }

    private void removeOutdatedEntries(World world, BlockPos playerPos, int updateRange) {
        MiningGoggles.EXECUTORS.submit(() -> {
            for (RenderOre ore : renderingOre) {
                boolean exist;
                boolean withinX = ore.pos.func_177958_n() + updateRange > playerPos.func_177958_n() || ore.pos.func_177958_n() - updateRange > playerPos.func_177958_n();
                boolean withinY = ore.pos.func_177956_o() + updateRange > playerPos.func_177956_o() || ore.pos.func_177956_o() - updateRange > playerPos.func_177956_o();
                boolean withinZ = ore.pos.func_177952_p() + updateRange > playerPos.func_177952_p() || ore.pos.func_177952_p() - updateRange > playerPos.func_177952_p();
                boolean bl = exist = world.func_180495_p(ore.pos).func_177230_c() != Blocks.field_150350_a;
                if (withinX && withinY && withinZ && exist) continue;
                renderingOre.remove(ore);
            }
        });
    }

    private double calcRangeModifier(int range) {
        if (range > 4) {
            if (range <= 64) {
                return ConfigHandler.gogglesUpdateFrequency + range / 4;
            }
            if (range <= 256) {
                return ConfigHandler.gogglesUpdateFrequency + range;
            }
            return ConfigHandler.gogglesUpdateFrequency + 2 * range;
        }
        return ConfigHandler.gogglesUpdateFrequency;
    }

    private boolean checkArmor(EntityPlayer player) {
        return this.getGoggles(player) != ItemStack.field_190927_a && this.getGoggles(player).func_77973_b() instanceof ItemGogglesMining;
    }

    private void validatePos(World world, BlockPos pos, EntityPlayer player) {
        if (world.func_180495_p(pos).func_177230_c() instanceof Block && world.func_180495_p(pos).func_177230_c() != Blocks.field_150350_a) {
            IBlockState state = world.func_180495_p(pos);
            int oreColor = MiningGoggleEffect.getColorForOre(this.getGoggles(player).func_77978_p().func_74775_l("filters"), world.func_180495_p(pos), world.func_175625_s(pos));
            if (oreColor != -1) {
                oreTargets.add(new RenderOre(world, player, pos, world.func_175625_s(pos), oreColor));
            }
        }
    }

    private static int getColorForOre(NBTTagCompound filterData, IBlockState block, TileEntity entity) {
        int oreColor = MiningGoggleEffect.getOreData(filterData, block);
        if (oreColor != -1) {
            return ORE_COLOR[oreColor];
        }
        return -1;
    }

    private static int getOreData(NBTTagCompound filterData, IBlockState block) {
        if (filterData == null || filterData.func_82582_d() || block.func_177230_c() == Blocks.field_150350_a) {
            return -1;
        }
        filterCache.clear();
        for (int index = 0; index < 16; ++index) {
            String[] filter;
            if (filterData.func_74779_i("color" + index).contains("9")) continue;
            for (String f : filter = filterData.func_74779_i("color" + index).replaceAll("9", "").split(";")) {
                filterCache.put(f, index);
            }
        }
        for (String name : MiningGoggleEffect.getBlockNames(block)) {
            if (!filterCache.containsKey(name)) continue;
            return filterCache.get(name);
        }
        return -1;
    }

    private static String[] getBlockNames(IBlockState block) {
        ItemStack itemBlock = new ItemStack(Item.func_150898_a((Block)block.func_177230_c()), 1, block.func_177230_c().func_176201_c(block));
        if (itemBlock != ItemStack.field_190927_a && !itemBlock.func_190926_b()) {
            return Arrays.stream(OreDictionary.getOreIDs((ItemStack)itemBlock)).mapToObj(OreDictionary::getOreName).collect(Collectors.toList()).toArray(new String[0]);
        }
        return new String[0];
    }
}

