/*
 * Decompiled with CFR 0.152.
 */
package com.wurmatron.mininggoggles.client.gui;

import com.wurmatron.mininggoggles.client.gui.GuiColorFilter;
import com.wurmatron.mininggoggles.common.network.NetworkHandler;
import com.wurmatron.mininggoggles.common.network.packets.UpdateHelmetConfig;
import java.io.IOException;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Mouse;

public class GuiGogglesFilter
extends GuiScreen {
    public static final ResourceLocation TEXTURE = new ResourceLocation("mininggoggles", "textures/gui/gogglesFilter.png");
    private GuiColorFilter[] filters = new GuiColorFilter[16];
    private int startingIndex = 0;
    private ItemStack stack;

    public GuiGogglesFilter(ItemStack stack) {
        this.stack = stack;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        int index;
        super.func_73863_a(mouseX, mouseY, partialTicks);
        int guiWidth = (this.field_146294_l - 218) / 2;
        int guiHeight = (this.field_146295_m - 154) / 2;
        this.field_146297_k.field_71446_o.func_110577_a(TEXTURE);
        this.func_73729_b((this.field_146294_l - 218) / 2, (this.field_146295_m - 154) / 2, 0, 0, 218, 154);
        this.func_73729_b((this.field_146294_l - 218) / 2 + 199, (this.field_146295_m - 154) / 2 + 6 + (int)(8.875f * (float)this.startingIndex), 219, 6, 12, 53);
        for (index = this.startingIndex; index < this.startingIndex + 6; ++index) {
            this.filters[index].text.field_146209_f = guiWidth + 29;
            this.filters[index].text.field_146210_g = guiHeight + 8 + 24 * (index - this.startingIndex);
            this.filters[index].draw();
        }
        for (index = this.startingIndex; index < this.startingIndex + 6; ++index) {
            this.filters[index].text.func_146194_f();
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        GuiColorFilter.ID_COUNTER = 0;
        int guiWidth = (this.field_146294_l - 218) / 2;
        int guiHeight = (this.field_146295_m - 154) / 2;
        for (int index = 0; index < 16; ++index) {
            this.filters[index] = new GuiColorFilter();
            this.filters[index].init();
            this.filters[index].text.field_146209_f = guiWidth + 29;
            this.filters[index].text.field_146210_g = guiHeight + 8 + 24 * index;
            if (!this.stack.func_77942_o() || !this.stack.func_77978_p().func_74764_b("filters") || !this.stack.func_77978_p().func_74775_l("filters").func_74764_b("color" + index)) continue;
            String oreEntry = this.stack.func_77978_p().func_74775_l("filters").func_74779_i("color" + index);
            if (oreEntry.contains("9")) {
                oreEntry = oreEntry.substring(0, oreEntry.length() - 1);
                this.filters[index].enabled = false;
            } else {
                this.filters[index].enabled = true;
            }
            this.filters[index].text.func_146180_a(oreEntry);
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        for (GuiColorFilter filter : this.filters) {
            filter.text.func_146192_a(mouseX, mouseY, mouseButton);
            if (!this.isWithin(mouseX, mouseY, filter.text.field_146209_f - 20, filter.text.field_146210_g, filter.text.field_146209_f, filter.text.field_146210_g + 18)) continue;
            filter.enabled = !filter.enabled;
        }
    }

    private boolean isWithin(int mouseX, int mouseY, int minX, int minY, int maxX, int maxY) {
        return mouseX >= minX && mouseY >= minY && mouseX <= maxX && mouseY <= maxY;
    }

    public void func_73876_c() {
        super.func_73876_c();
        for (GuiColorFilter filter : this.filters) {
            filter.text.func_146178_a();
        }
        int dWheel = Mouse.getDWheel();
        if (dWheel < 0) {
            this.moveDown();
        } else if (dWheel > 0) {
            this.moveUp();
        }
    }

    public void func_146281_b() {
        super.func_146281_b();
        NetworkHandler.sendToServer(new UpdateHelmetConfig(this.collectNBTData()));
    }

    private NBTTagCompound collectNBTData() {
        NBTTagCompound nbt = new NBTTagCompound();
        for (GuiColorFilter filter : this.filters) {
            nbt.func_74778_a("color" + filter.getID(), filter.text.func_146179_b() + (filter.enabled ? "" : "9"));
        }
        return nbt;
    }

    public void func_73869_a(char c, int i) throws IOException {
        if (i == 1) {
            super.func_73869_a(c, i);
        } else if (i == 208) {
            this.moveDown();
        } else if (i == 200) {
            this.moveUp();
        } else if (i == 28) {
            for (GuiColorFilter filter : this.filters) {
                filter.text.func_146195_b(false);
            }
        } else {
            for (GuiColorFilter filter : this.filters) {
                if (!filter.text.func_146206_l()) continue;
                if (Character.isAlphabetic(c) || i == 39) {
                    filter.text.func_146201_a(c, i);
                    continue;
                }
                if (i != 211 && i != 14 || filter.text.func_146179_b().isEmpty()) continue;
                filter.text.func_146180_a(filter.text.func_146179_b().substring(0, filter.text.func_146179_b().length() - 1));
            }
        }
    }

    private void resetFocus() {
        for (GuiColorFilter filter : this.filters) {
            filter.text.func_146195_b(false);
        }
    }

    private void moveDown() {
        this.resetFocus();
        ++this.startingIndex;
        if (this.startingIndex + 6 >= 16) {
            this.startingIndex = 10;
        }
    }

    private void moveUp() {
        this.resetFocus();
        --this.startingIndex;
        if (this.startingIndex < 0) {
            this.startingIndex = 0;
        }
    }
}

