/*
 * Decompiled with CFR 0.152.
 */
package com.wurmatron.mininggoggles.client;

import com.wurmatron.mininggoggles.client.render.MiningGoggleEffect;
import com.wurmatron.mininggoggles.common.CommonProxy;
import com.wurmatron.mininggoggles.common.items.ItemModule;
import com.wurmatron.mininggoggles.common.items.MiningRegistry;
import com.wurmatron.mininggoggles.common.items.baubles.ItemGogglesMiningBaubles;
import com.wurmatron.mininggoggles.common.network.GuiHandler;
import com.wurmatron.mininggoggles.common.network.NetworkHandler;
import com.wurmatron.mininggoggles.common.network.packets.OpenGuiMessage;
import com.wurmatron.mininggoggles.common.registry.Registry;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IThreadListener;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class ClientProxy
extends CommonProxy {
    public static KeyBinding[] keyBindings;

    @Override
    public void preInit() {
        MinecraftForge.EVENT_BUS.register((Object)new ClientProxy());
        for (KeyBinding key : keyBindings = new KeyBinding[]{new KeyBinding("key.toggle.desc", 49, "key.mininggoggles.category"), new KeyBinding("key.filter.desc", 48, "key.mininggoggles.category")}) {
            ClientRegistry.registerKeyBinding((KeyBinding)key);
        }
    }

    @Override
    public void init() {
        MinecraftForge.EVENT_BUS.register((Object)new MiningGoggleEffect());
        if (Loader.isModLoaded((String)"baubles")) {
            MinecraftForge.EVENT_BUS.register((Object)new ItemGogglesMiningBaubles(MiningRegistry.gogglesMaterial));
        }
    }

    @SubscribeEvent
    public void modelBakeEvent(ModelRegistryEvent e) {
        ClientProxy.createModel(MiningRegistry.gogglesMining, MiningRegistry.gogglesMining.func_77658_a().substring(5));
        for (int index = 0; index < ItemModule.metaItems.length; ++index) {
            ClientProxy.createModel(MiningRegistry.itemModule, index, ItemModule.metaItems[index]);
        }
    }

    @SubscribeEvent
    public void textureStich(TextureStitchEvent.Pre e) {
        e.getMap().func_174942_a(new ResourceLocation("mininggoggles", "gui/moduleicon"));
    }

    private static void createModel(Block block, int meta, String name) {
        ModelLoader.setCustomModelResourceLocation((Item)Registry.blockItems.get(block), (int)meta, (ModelResourceLocation)new ModelResourceLocation("mininggoggles:" + name, "inventory"));
    }

    private static void createModel(Item item, String name) {
        ClientProxy.createModel(item, 0, name);
    }

    private static void createModel(Item item, int meta, String name) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation("mininggoggles:" + name, "inventory"));
    }

    @Override
    public EntityPlayer getPlayer(MessageContext ctx) {
        return ctx.side.isClient() ? Minecraft.func_71410_x().field_71439_g : super.getPlayer(ctx);
    }

    @Override
    public IThreadListener getThreadFromCTX(MessageContext ctx) {
        return ctx.side.isClient() ? Minecraft.func_71410_x() : super.getThreadFromCTX(ctx);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onClientTick(TickEvent.ClientTickEvent e) throws Exception {
        if (keyBindings[0].func_151468_f()) {
            if (GuiHandler.getActiveGoggles((EntityPlayer)Minecraft.func_71410_x().field_71439_g) != ItemStack.field_190927_a) {
                NetworkHandler.sendToServer(new OpenGuiMessage(1, Minecraft.func_71410_x().field_71439_g.func_180425_c()));
            } else {
                Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TextComponentString(I18n.func_74838_a((String)"chat.gogglesmissing.name")));
            }
        } else if (keyBindings[1].func_151468_f()) {
            if (GuiHandler.getActiveGoggles((EntityPlayer)Minecraft.func_71410_x().field_71439_g) != ItemStack.field_190927_a) {
                NetworkHandler.sendToServer(new OpenGuiMessage(0, Minecraft.func_71410_x().field_71439_g.func_180425_c()));
            } else {
                Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TextComponentTranslation(I18n.func_74838_a((String)"chat.gogglesmissing.name"), new Object[0]));
            }
        }
    }
}

