/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core.util.registry;

import aroma1997.core.log.LogHelper;
import aroma1997.core.util.Util;
import aroma1997.core.util.registry.AutoRegisterInfoClass;
import aroma1997.core.util.registry.IAutoRegisterInfo;
import aroma1997.core.util.registry.IRegistryCallable;
import com.google.common.base.Throwables;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Level;

public final class AromaAutoRegistry
extends Enum<AromaAutoRegistry> {
    public static final /* enum */ AromaAutoRegistry INSTANCE = new AromaAutoRegistry();
    private List<IAutoRegisterInfo> registeredInfos = new ArrayList<IAutoRegisterInfo>();
    private static final /* synthetic */ AromaAutoRegistry[] $VALUES;

    public static AromaAutoRegistry[] values() {
        return (AromaAutoRegistry[])$VALUES.clone();
    }

    public static AromaAutoRegistry valueOf(String name) {
        return Enum.valueOf(AromaAutoRegistry.class, name);
    }

    private AromaAutoRegistry() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public <T> void registerClassWrapper(Class<T> clazz, T o) {
        AutoRegisterInfoClass<T> info = new AutoRegisterInfoClass<T>(clazz, o, Util.getCurrentModName());
        this.registeredInfos.add(info);
    }

    public void registerInfo(IAutoRegisterInfo info) {
        assert (info != null);
        this.registeredInfos.add(info);
    }

    public void forEach(Consumer<IAutoRegisterInfo> method) {
        ModContainer originalMc = Loader.instance().activeModContainer();
        for (IAutoRegisterInfo info : this.registeredInfos) {
            Loader.instance().setActiveModContainer(Util.getModContainerFor(info.getModId()));
            method.accept(info);
        }
        Loader.instance().setActiveModContainer(originalMc);
    }

    @Deprecated
    public void init() {
        INSTANCE.forEach(ainfo -> {
            if (!(ainfo instanceof AutoRegisterInfoClass)) {
                return;
            }
            AutoRegisterInfoClass info = (AutoRegisterInfoClass)ainfo;
            try {
                Method m = info.getRegisterClass().getMethod("init", new Class[0]);
                if (!m.isAccessible()) {
                    m.setAccessible(true);
                }
                m.invoke(info.getRegisterInstance(), new Object[0]);
            }
            catch (NoSuchMethodException m) {
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                LogHelper.log(Level.ERROR, "There is a problem with initializing: " + info);
                Throwables.propagate((Throwable)e);
            }
            catch (InvocationTargetException e) {
                Throwables.propagate((Throwable)e.getCause());
            }
            catch (SecurityException e) {
                Throwables.propagate((Throwable)e);
            }
        });
    }

    @SubscribeEvent
    public void registerRegistry(RegistryEvent.Register event) {
        this.forEach(info -> AromaAutoRegistry.registerBlocksItems(info, event.getRegistry()));
    }

    private static <T, C extends IForgeRegistryEntry<C>, R extends IForgeRegistry<C>> void registerBlocksItems(IAutoRegisterInfo info, R registry) {
        Class clazz = registry.getRegistrySuperType();
        Collection toRegister = info.getValuesApplicableFor(clazz);
        for (IForgeRegistryEntry current : toRegister) {
            if (current instanceof IRegistryCallable) {
                ((IRegistryCallable)current).preRegister();
            }
            registry.register(current);
            if (!(current instanceof IRegistryCallable)) continue;
            ((IRegistryCallable)current).postRegister();
        }
        if (!toRegister.isEmpty()) {
            LogHelper.log(Level.INFO, "Successfully registered " + toRegister.size() + " " + clazz.getSimpleName() + "s for " + clazz + " from " + info.getModId() + ".");
        } else {
            LogHelper.log(Level.TRACE, "No " + clazz.getSimpleName() + "s needed to be registered from mod " + info.getModId() + ".");
        }
    }

    static {
        $VALUES = new AromaAutoRegistry[]{INSTANCE};
    }
}

