/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core.inventory;

import aroma1997.core.util.ItemUtil;
import java.util.Arrays;
import java.util.Iterator;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;

public class InvUtil {
    public static NBTTagCompound writeToNBT(IInventory inv, NBTTagCompound nbt) {
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack item = inv.func_70301_a(i);
            if (item == null || item.func_190926_b()) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)i);
            item.func_77955_b(tag);
            list.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("Items", (NBTBase)list);
        return nbt;
    }

    public static void readFromNBT(IInventory inv, NBTTagCompound nbt) {
        inv.func_174888_l();
        NBTTagList list = nbt.func_150295_c("Items", (int)new NBTTagCompound().func_74732_a());
        for (int i = 0; i < list.func_74745_c(); ++i) {
            ItemStack item;
            NBTTagCompound tagT = list.func_150305_b(i);
            int tag = tagT.func_74771_c("Slot") & 0xFF;
            if (tag < 0 || tag >= inv.func_70302_i_() || (item = new ItemStack(tagT)).func_190926_b()) continue;
            inv.func_70299_a(tag, item);
        }
    }

    private static IntPredicate getAcceptanceForInsert(IInventory inv, ItemStack stack, boolean checkAcceptance, EnumFacing dir) {
        IntPredicate acceptance = checkAcceptance && inv instanceof ISidedInventory ? i -> ((ISidedInventory)inv).func_180462_a(i, stack, dir) : i -> inv.func_94041_b(i, stack);
        return acceptance;
    }

    private static IntPredicate getAcceptanceForExtract(IInventory inv, boolean checkAcceptance, EnumFacing dir) {
        IntPredicate acceptance = !checkAcceptance ? i -> true : (inv instanceof ISidedInventory ? i -> ((ISidedInventory)inv).func_180462_a(i, inv.func_70301_a(i), dir) : i -> inv.func_94041_b(i, inv.func_70301_a(i)));
        return acceptance;
    }

    public static ItemStack putStackInInventoryInternal(ItemStack stack, IInventory inv, boolean simulate) {
        return InvUtil.putStackInInventory(stack, inv, true, false, simulate, null);
    }

    public static ItemStack putStackInInventory(ItemStack stack, IInventory inv, boolean checkAcceptanceSlot, boolean checkAcceptanceInsert, boolean simulate, EnumFacing dir) {
        int run;
        ItemStack workingStack = stack.func_77946_l();
        IntPredicate acceptance = InvUtil.getAcceptanceForInsert(inv, stack, checkAcceptanceInsert, dir);
        int n = run = simulate ? 1 : 0;
        while (run < 2) {
            boolean acceptEmptySlots;
            boolean bl = acceptEmptySlots = run > 0;
            if (checkAcceptanceSlot && inv instanceof ISidedInventory) {
                for (int i : ((ISidedInventory)inv).func_180463_a(dir)) {
                    ItemStack current = inv.func_70301_a(i);
                    if (!acceptance.test(i) || !simulate && current.func_190926_b() != acceptEmptySlots || !(workingStack = InvUtil.tryPutStackInSlotChangeStack(workingStack, inv, i, simulate)).func_190926_b()) {
                        continue;
                    }
                    break;
                }
            } else {
                for (int i = 0; i < inv.func_70302_i_() && !workingStack.func_190926_b(); ++i) {
                    ItemStack current = inv.func_70301_a(i);
                    if (!acceptance.test(i) || !simulate && current.func_190926_b() != acceptEmptySlots) continue;
                    workingStack = InvUtil.tryPutStackInSlotChangeStack(workingStack, inv, i, simulate);
                }
            }
            ++run;
        }
        if (!simulate && workingStack.func_190916_E() != stack.func_190916_E()) {
            inv.func_70296_d();
        }
        return workingStack;
    }

    public static ItemStack putStackInInventoryFirst(ItemStack stack, IInventory inv, boolean checkAcceptanceSlot, boolean checkAcceptanceInsert, boolean simulate, EnumFacing dir) {
        ItemStack workingStack = stack.func_77946_l();
        IntPredicate acceptance = InvUtil.getAcceptanceForInsert(inv, stack, checkAcceptanceInsert, dir);
        if (checkAcceptanceSlot && inv instanceof ISidedInventory) {
            for (int slot : ((ISidedInventory)inv).func_180463_a(dir)) {
                if (!workingStack.func_190926_b()) {
                    if (!acceptance.test(slot)) continue;
                    InvUtil.tryPutStackInSlotChangeStack(workingStack, inv, slot, simulate);
                    continue;
                }
                break;
            }
        } else {
            for (int i = 0; i < inv.func_70302_i_() && !workingStack.func_190926_b(); ++i) {
                if (!acceptance.test(i)) continue;
                InvUtil.tryPutStackInSlotChangeStack(workingStack, inv, i, simulate);
            }
        }
        return workingStack;
    }

    private static ItemStack tryPutStackInSlotChangeStack(ItemStack stack, IInventory inv, int slot, boolean simulate) {
        int toAdd;
        int maxStackSize = Math.min(inv.func_70297_j_(), stack.func_77976_d());
        ItemStack stackInInv = inv.func_70301_a(slot);
        if (stackInInv.func_190926_b()) {
            int toAdd2 = Math.min(maxStackSize, stack.func_190916_E());
            if (!simulate) {
                ItemStack stackToAdd = stack.func_77946_l();
                stackToAdd.func_190920_e(toAdd2);
                inv.func_70299_a(slot, stackToAdd);
            }
            stack.func_190920_e(stack.func_190916_E() - toAdd2);
        } else if (ItemUtil.areItemsSameMatching(stack, stackInInv, ItemUtil.IItemMatchCriteria.ID, ItemUtil.IItemMatchCriteria.DAMAGE, ItemUtil.IItemMatchCriteria.NBT) && (toAdd = Math.min(stack.func_190916_E(), maxStackSize - stackInInv.func_190916_E())) > 0) {
            stack.func_190920_e(stack.func_190916_E() - toAdd);
            if (!simulate) {
                stackInInv.func_190920_e(stackInInv.func_190916_E() + toAdd);
            }
        }
        return stack;
    }

    public static Iterable<ItemStack> getFromInv(final IInventory inv) {
        if (inv instanceof ISidedInventory) {
            return () -> Arrays.stream(((ISidedInventory)inv).func_180463_a(null)).mapToObj(i -> inv.func_70301_a(i)).iterator();
        }
        return new Iterable<ItemStack>(){

            @Override
            public Iterator<ItemStack> iterator() {
                return new Iterator<ItemStack>(){
                    int idx = 0;

                    @Override
                    public boolean hasNext() {
                        return this.idx < inv.func_70302_i_();
                    }

                    @Override
                    public ItemStack next() {
                        return inv.func_70301_a(this.idx++);
                    }
                };
            }
        };
    }

    public static Stream<ItemStack> getInvStream(IInventory inv) {
        IntStream slots = inv instanceof ISidedInventory ? IntStream.of(((ISidedInventory)inv).func_180463_a(null)) : IntStream.range(0, inv.func_70302_i_());
        return slots.mapToObj(arg_0 -> ((IInventory)inv).func_70301_a(arg_0));
    }

    public static int findInInv(IInventory inv, boolean cheackAcceptanceSlot, boolean checkAcceptanceExtract, EnumFacing side, Predicate<ItemStack> predicate) {
        IntPredicate acceptance = InvUtil.getAcceptanceForExtract(inv, checkAcceptanceExtract, side);
        if (cheackAcceptanceSlot && inv instanceof ISidedInventory) {
            for (int slot : ((ISidedInventory)inv).func_180463_a(side)) {
                if (!acceptance.test(slot) || !predicate.test(inv.func_70301_a(slot))) continue;
                return slot;
            }
        } else {
            for (int slot = 0; slot < inv.func_70302_i_(); ++slot) {
                if (!acceptance.test(slot) || !predicate.test(inv.func_70301_a(slot))) continue;
                return slot;
            }
        }
        return -1;
    }

    public static int findInInvInternal(IInventory inv, EnumFacing dir, Predicate<ItemStack> matches) {
        return InvUtil.findInInv(inv, true, false, dir, matches);
    }
}

