/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.gui.statement;

import buildcraft.api.core.render.ISprite;
import buildcraft.api.statements.IGuiSlot;
import buildcraft.api.statements.IStatement;
import buildcraft.lib.BCLibSprites;
import buildcraft.lib.client.sprite.SpriteNineSliced;
import buildcraft.lib.client.sprite.SpriteRaw;
import buildcraft.lib.gui.BuildCraftGui;
import buildcraft.lib.gui.GuiElementSimple;
import buildcraft.lib.gui.GuiIcon;
import buildcraft.lib.gui.IInteractionElement;
import buildcraft.lib.gui.elem.ToolTip;
import buildcraft.lib.gui.pos.IGuiArea;
import buildcraft.lib.gui.statement.GuiElementStatementSource;
import buildcraft.lib.gui.statement.GuiElementStatementVariant;
import buildcraft.lib.misc.data.IReference;
import buildcraft.lib.statement.FullStatement;
import buildcraft.lib.statement.StatementContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ResourceLocation;

public class GuiElementStatement<S extends IStatement>
extends GuiElementSimple
implements IInteractionElement,
IReference<S> {
    public static final ResourceLocation TEXTURE_SELECTOR = new ResourceLocation("buildcraftlib:textures/gui/misc_slots.png");
    public static final GuiIcon SLOT_COLOUR = new GuiIcon(TEXTURE_SELECTOR, 0.0, 0.0, 18.0, 18.0);
    public static final GuiIcon ICON_SLOT_BLOCKED = SLOT_COLOUR.offset(18.0, 0.0);
    public static final GuiIcon ICON_SLOT_NOT_SET = ICON_SLOT_BLOCKED.offset(18.0, 0.0);
    public static final SpriteRaw ICON_SELECT_HOVER = new SpriteRaw(TEXTURE_SELECTOR, 18.0, 18.0, 36.0, 36.0, 256.0);
    public static final SpriteNineSliced SELECTION_HOVER = new SpriteNineSliced((ISprite)ICON_SELECT_HOVER, 8, 8, 28, 28, 36);
    private final FullStatement<S> ref;
    private final StatementContext<?> ctx;
    private final boolean draw;

    public GuiElementStatement(BuildCraftGui gui, IGuiArea element, FullStatement<S> ref, StatementContext<?> ctx, boolean draw) {
        super(gui, element);
        this.ref = ref;
        this.ctx = ctx;
        this.draw = draw;
    }

    @Override
    public S get() {
        return (S)this.ref.get();
    }

    @Override
    public void set(S to) {
        this.ref.set(to);
        this.ref.postSetFromGui(-1);
    }

    @Override
    public boolean canSet(S value) {
        return this.ref.canSet(value);
    }

    @Override
    public S convertToType(Object value) {
        return (S)this.ref.convertToType(value);
    }

    @Override
    public Class<S> getHeldType() {
        return this.ref.getHeldType();
    }

    @Override
    public void addToolTips(List<ToolTip> tooltips) {
        Object s;
        if (this.contains(this.gui.mouse) && (s = this.get()) != null) {
            tooltips.add(new ToolTip(s.getTooltip()));
        }
    }

    @Override
    public void drawBackground(float partialTicks) {
        if (this.draw) {
            Object statement = this.ref.get();
            double x = this.getX();
            double y = this.getY();
            GuiElementStatementSource.drawGuiSlot((IGuiSlot)statement, x, y);
            if (!this.ref.canInteract) {
                GuiIcon.drawAt(BCLibSprites.LOCK, x + 1.0, y + 1.0, 16.0);
            }
        }
    }

    @Override
    public void onMouseClicked(int button) {
        if (!this.contains(this.gui.mouse)) {
            return;
        }
        if (this.ref.canInteract && button == 0) {
            if (GuiScreen.func_146272_n()) {
                this.set((S)null);
                return;
            }
            Object s = this.get();
            if (s == null) {
                return;
            }
            ArrayList<IStatement> possible = new ArrayList<IStatement>();
            Collections.addAll(possible, s.getPossible());
            if (!s.isPossibleOrdered()) {
                ArrayList<IStatement> list = new ArrayList<IStatement>();
                list.add(null);
                for (IStatement p2 : possible) {
                    if (p2 == null) continue;
                    list.add(p2);
                }
                possible = list;
            }
            if (this.ctx != null) {
                possible.removeIf(f -> {
                    for (StatementContext.StatementGroup<?> group : this.ctx.getAllPossible()) {
                        if (!group.getValues().contains(f)) continue;
                        return false;
                    }
                    return true;
                });
            }
            this.gui.currentMenu = GuiElementStatementVariant.create(this.gui, this, this, possible.toArray(new IStatement[0]));
        }
    }
}

